<?php

add_shortcode('whatsapp_widget_generator', 'render_whatsapp_widget_generator');

function render_whatsapp_widget_generator() {
    ob_start();
    wp_enqueue_style( 'jd-whatsapp-css');
    ?>
    <main class="container">
<div id="generator-tool-container">
    <div class="generator-grid">
        <!-- Left Column: Form -->
        <div class="generator-form">
            <form id="generatorForm" onsubmit="return false;">
               <div class="accordion-container">
                    <div class="accordion-header is-open">Content
                        <svg xmlns="http://www.w3.org/2000/svg" id="Icons_16px"  width="20" height="20" viewbox="0 0 20 20">
                        <rect width="20" height="20" fill="none"/>
                        <g>
                            <path   d="M0,0H20V20H0Z" fill="none"/>
                            <path d="M6.4,14.5a1,1,0,0,1-.758-.346L.243,7.9a1,1,0,0,1,0-1.307l5.4-6.25A1,1,0,1,1,7.155,1.654L2.322,7.25l4.832,5.6A1,1,0,0,1,6.4,14.5Z" transform="translate(2.75 13.898) rotate(-90)" fill="#1a202c"/>
                        </g>
                    </svg>
                </div>
                <div class="accordion-content"> 
                    <fieldset>
                        <!-- <legend>Content</legend> -->
                        <div class="form-group">
                            <label for="brandName">Brand Name</label>
                            <input type="text" id="brandName" value="JoomDev">
                        </div>
                        <div class="form-group">
                            <label for="whatsappNumber">WhatsApp Number (with country code, no '+')</label>
                            <input type="tel" id="whatsappNumber" placeholder="e.g., 15551234567" required>
                        </div>
                        <div class="form-group">
                            <label for="brandImageUrl">Brand Image URL (Logo)</label>
                            <input type="url" id="brandImageUrl" placeholder="https://your-website.com/logo.png">
                        </div>
                        <div class="form-group">
                            <label for="welcomeMessage">Welcome Message</label>
                            <textarea id="welcomeMessage">Hello! How can we assist you today?</textarea>
                        </div>
                        <div class="form-group">
                            <label for="prefilledMessage">Pre-filled Message</label>
                            <textarea id="prefilledMessage">Hello, I have a question about...</textarea>
                        </div>
                    </fieldset> 
                </div>
               </div>
               
              <div class="accordion-container">
                    <div class="accordion-header">Appearance
                    <svg xmlns="http://www.w3.org/2000/svg" id="Icons_16px"  width="20" height="20" viewbox="0 0 20 20">
                        <rect width="20" height="20" fill="none"/>
                        <g>
                            <path   d="M0,0H20V20H0Z" fill="none"/>
                            <path d="M6.4,14.5a1,1,0,0,1-.758-.346L.243,7.9a1,1,0,0,1,0-1.307l5.4-6.25A1,1,0,1,1,7.155,1.654L2.322,7.25l4.832,5.6A1,1,0,0,1,6.4,14.5Z" transform="translate(2.75 13.898) rotate(-90)" fill="#1a202c"/>
                        </g>
                    </svg>
                </div>
                <div class="accordion-content"> 
                    <fieldset>
                        <!-- <legend>Appearance</legend>       -->
                        <div class="form-group w-48" >
                            <label for="brandColor">Primary Color</label>
                            <div class="color-picker-group">
                                <input type="color" id="brandColorPicker" value="#00b859">
                                <input type="text" id="brandColorText" value="#00b859">
                            </div>
                        </div>
                        <div class="form-group w-48">
                            <label for="chatButtonColor">Icon Color</label>
                            <div class="color-picker-group">
                                <input type="color" id="chatButtonColorPicker" value="#FFFFFF">
                                <input type="text" id="chatButtonColorText" value="#FFFFFF">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="buttonText">Chat Button Text (in Widget)</label>
                            <input type="text" id="buttonText" value="Chat with us">
                        </div>
                        <div class="form-group">
                            <label for="backgroundImageUrl">Background Image URL</label>
                            <input type="url" id="backgroundImageUrl" placeholder="https://your-website.com/whatsappbgimage.png">
                        </div>
                        <div class="form-group">
                            <label>Floating Button Position</label>
                            <div class="radio-group" id="buttonPositionGroup">
                                <label>
                                    <input type="radio" name="buttonPosition" value="bottom-right" checked>
                                    Bottom Right
                                </label>
                                <label>
                                    <input type="radio" name="buttonPosition" value="bottom-left">
                                    Bottom Left
                                </label>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Floating Button Icon</label>
                                <div class="icon-selector" id="chatButtonIconGroup">
                                    <label>
                                        <input type="radio" name="chatButtonIcon" value="whatsappv1" checked>
                                        <span class="icon-option" title="whatsappv1"></span>
                                    </label>
                                    <label>
                                        <input type="radio" name="chatButtonIcon" value="whatsapp">
                                        <span class="icon-option" title="WhatsApp"></span>
                                    </label>
                                    <label>
                                        <input type="radio" name="chatButtonIcon" value="chat">
                                        <span class="icon-option" title="Chat Bubble"></span>
                                    </label>
                                <!-- <label>
                                    <input type="radio" name="chatButtonIcon" value="message">
                                    <span class="icon-option" title="Message"></span>
                                </label>
                                <label>
                                    <input type="radio" name="chatButtonIcon" value="whatsappcall">
                                    <span class="icon-option" title="whatsappcall"></span>
                                </label> -->
                                    <label>
                                        <input type="radio" name="chatButtonIcon" value="whatsappv2">
                                        <span class="icon-option" title="whatsappv2"></span>
                                    </label>
                               
                            </div>
                        </div>
                    
                    </fieldset>
                </div>
              </div>
              
                <fieldset style="margin-top:15px;"> 
                    <div class="form-group">
                        <button class="generateBtn" id="generateBtn">Generate WhatsApp Chat Widget Code</button>
                    </div>
                </fieldset> 
            </form>
        </div>
        <!-- Right Column: Code Output -->
        <div class="generator-output">
                <div class="preview-section">
                <h2>Your WhatsApp Chat Button Preview</h2>
                <div id="preview-area">
                    <div id="preview-widget">
                        <div id="preview-widget-header">
                            <img id="preview-widget-logo" src="" alt="Brand Logo">
                            <span id="preview-widget-brand">Brand Name</span>
                        </div>
                        <div id="preview-widget-body">
                            <p id="preview-widget-message">Welcome message here.</p>
                        </div>
                        <div id="preview-widget-footer">
                            <a id="preview-widget-button" href="#" target="_blank" rel="noopener noreferrer">Chat button text</a>
                        </div>
                    </div>
                    <button id="preview-float-button" class="bottom-right">
                        <span id="preview-icon"></span>
                    </button>
                </div>
            </div>
            <!-- start generated code. -->
                <div id="genrated-code-box" style="display:none;">
            <h3>Your Embed Code</h3>
                <div class="output-code-container">
                <div class="code-header">
                    <p style="margin:0; font-size: 0.9rem;">Copy and paste this code into your website's HTML.</p>
                    <button id="copyCodeBtn" class="copy-button">Copy Code</button>
                </div>
                <textarea id="generated-code" readonly></textarea>
            </div>
            </div>
            <!-- end of generated code field. -->
        </div>
    </div>
</div>
</main>

<script>
(() => {
const form = document.getElementById('generatorForm');
if (!form) return;

    const icons = {
    whatsapp: `<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 448 512" aria-hidden="true"><path fill="currentColor" d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zM223.9 148.1c-10.9 0-19.8 8.9-19.8 19.8v.1c0 10.9 8.9 19.8 19.8 19.8h.1c10.9 0 19.8-8.9 19.8-19.8v-.1c0-10.9-8.9-19.8-19.8-19.8zm69.2 81.8c-3.3-1.6-19.8-9.8-22.8-10.9-3.1-1.1-5.3-1.6-7.6 1.6-2.3 3.3-8.6 10.9-10.6 13.1-1.9 2.3-3.9 2.5-7.1 1s-13.6-5-25.9-16c-9.6-8.5-16.1-19-18-22.3-1.9-3.3-.2-5.1.9-6.7 1-1.5 2.3-3.9 3.4-5.6 1.1-1.7 1.5-2.8 2.3-4.7 1.1-1.9.1-3.6-1-5.3-1.1-1.7-7.6-18.2-10.3-24.9-2.8-6.8-5.6-5.8-7.8-5.9-2.1-.1-4.4-.1-6.6-.1-2.3 0-5.9 1-8.9 4.1-3 3.1-11.4 11.1-11.4 27.1 0 16 11.7 31.4 13.3 33.6 1.6 2.3 22.8 36.3 55.1 48.7 7.5 2.8 13.4 4.5 17.9 5.8 9.3 2.6 17.6 2.3 24.1 1.4 7.5-1 22.8-9.3 26-18.2 3.3-8.9 3.3-16.5 2.3-18.2-1-1.8-3.3-2.8-6.6-4.6z"/></svg>`,
    chat: `<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 512 512" aria-hidden="true"><path fill="currentColor" d="M256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 401.8 7 439.4 6.5 439.8c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 278.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z"/></svg>`,
    // message: `<svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 512 512" aria-hidden="true"><path fill="currentColor" d="M48 64C21.5 64 0 85.5 0 112v288c0 26.5 21.5 48 48 48h368l96-96V112c0-26.5-21.5-48-48-48H48zM64 256c0-8.8 7.2-16 16-16h256c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16zm0-80c0-8.8 7.2-16 16-16h256c8.8 0 16 7.2 16 16s-7.2 16-16 16H80c-8.8 0-16-7.2-16-16zm272 160H80c-8.8 0-16 7.2-16 16s7.2 16 16 16h256c8.8 0 16-7.2 16-16s-7.2-16-16-16z"/></svg>`,
    //  whatsappcall: `<svg xmlns="http://www.w3.org/2000/svg"  viewbox="0 0 48 48" width="96px" height="96px" fill-rule="evenodd" clip-rule="evenodd"><path fill="#fff" d="M4.868,43.303l2.694-9.835C5.9,30.59,5.026,27.324,5.027,23.979C5.032,13.514,13.548,5,24.014,5c5.079,0.002,9.845,1.979,13.43,5.566c3.584,3.588,5.558,8.356,5.556,13.428c-0.004,10.465-8.522,18.98-18.986,18.98c-0.001,0,0,0,0,0h-0.008c-3.177-0.001-6.3-0.798-9.073-2.311L4.868,43.303z"/><path fill="#fff" d="M4.868,43.803c-0.132,0-0.26-0.052-0.355-0.148c-0.125-0.127-0.174-0.312-0.127-0.483l2.639-9.636c-1.636-2.906-2.499-6.206-2.497-9.556C4.532,13.238,13.273,4.5,24.014,4.5c5.21,0.002,10.105,2.031,13.784,5.713c3.679,3.683,5.704,8.577,5.702,13.781c-0.004,10.741-8.746,19.48-19.486,19.48c-3.189-0.001-6.344-0.788-9.144-2.277l-9.875,2.589C4.953,43.798,4.911,43.803,4.868,43.803z"/><path fill="#cfd8dc" d="M24.014,5c5.079,0.002,9.845,1.979,13.43,5.566c3.584,3.588,5.558,8.356,5.556,13.428c-0.004,10.465-8.522,18.98-18.986,18.98h-0.008c-3.177-0.001-6.3-0.798-9.073-2.311L4.868,43.303l2.694-9.835C5.9,30.59,5.026,27.324,5.027,23.979C5.032,13.514,13.548,5,24.014,5 M24.014,42.974C24.014,42.974,24.014,42.974,24.014,42.974C24.014,42.974,24.014,42.974,24.014,42.974 M24.014,42.974C24.014,42.974,24.014,42.974,24.014,42.974C24.014,42.974,24.014,42.974,24.014,42.974 M24.014,4C24.014,4,24.014,4,24.014,4C12.998,4,4.032,12.962,4.027,23.979c-0.001,3.367,0.849,6.685,2.461,9.622l-2.585,9.439c-0.094,0.345,0.002,0.713,0.254,0.967c0.19,0.192,0.447,0.297,0.711,0.297c0.085,0,0.17-0.011,0.254-0.033l9.687-2.54c2.828,1.468,5.998,2.243,9.197,2.244c11.024,0,19.99-8.963,19.995-19.98c0.002-5.339-2.075-10.359-5.848-14.135C34.378,6.083,29.357,4.002,24.014,4L24.014,4z"/><path fill="#40c351" d="M35.176,12.832c-2.98-2.982-6.941-4.625-11.157-4.626c-8.704,0-15.783,7.076-15.787,15.774c-0.001,2.981,0.833,5.883,2.413,8.396l0.376,0.597l-1.595,5.821l5.973-1.566l0.577,0.342c2.422,1.438,5.2,2.198,8.032,2.199h0.006c8.698,0,15.777-7.077,15.78-15.776C39.795,19.778,38.156,15.814,35.176,12.832z"/><path fill="#fff" fill-rule="evenodd" d="M19.268,16.045c-0.355-0.79-0.729-0.806-1.068-0.82c-0.277-0.012-0.593-0.011-0.909-0.011c-0.316,0-0.83,0.119-1.265,0.594c-0.435,0.475-1.661,1.622-1.661,3.956c0,2.334,1.7,4.59,1.937,4.906c0.237,0.316,3.282,5.259,8.104,7.161c4.007,1.58,4.823,1.266,5.693,1.187c0.87-0.079,2.807-1.147,3.202-2.255c0.395-1.108,0.395-2.057,0.277-2.255c-0.119-0.198-0.435-0.316-0.909-0.554s-2.807-1.385-3.242-1.543c-0.435-0.158-0.751-0.237-1.068,0.238c-0.316,0.474-1.225,1.543-1.502,1.859c-0.277,0.317-0.554,0.357-1.028,0.119c-0.474-0.238-2.002-0.738-3.815-2.354c-1.41-1.257-2.362-2.81-2.639-3.285c-0.277-0.474-0.03-0.731,0.208-0.968c0.213-0.213,0.474-0.554,0.712-0.831c0.237-0.277,0.316-0.475,0.474-0.791c0.158-0.317,0.079-0.594-0.04-0.831C20.612,19.329,19.69,16.983,19.268,16.045z" clip-rule="evenodd"/></svg>`,
        whatsappv2: `<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewbox="0 0 50 50">
    <path fill="currentColor" d="M 25 2 C 12.3 2 2 12.3 2 25 C 2 29.1 3.1 32.899219 5 36.199219 L 2 46.699219 C 1.9 46.999219 1.9992187 47.399219 2.1992188 47.699219 C 2.4992187 47.999219 2.8992187 48 3.1992188 48 L 14.199219 45.300781 C 17.399219 47.000781 21.1 48 25 48 C 37.7 48 48 37.7 48 25 C 48 12.3 37.7 2 25 2 z M 25 4 C 36.6 4 46 13.4 46 25 C 46 36.6 36.6 46 25 46 C 21.3 46 17.800781 45.000781 14.800781 43.300781 C 14.600781 43.200781 14.299609 43.099219 14.099609 43.199219 L 4.5 45.599609 L 7 36.400391 C 7.1 36.100391 7.0003906 35.899609 6.9003906 35.599609 C 5.1003906 32.499609 4 28.9 4 25 C 4 13.4 13.4 4 25 4 z M 18.113281 12.988281 C 17.925781 12.975781 17.800781 13 17.800781 13 L 16.599609 13 C 15.999609 13 15.100781 13.2 14.300781 14 C 13.800781 14.5 12 16.3 12 19.5 C 12 22.9 14.299609 25.799609 14.599609 26.099609 C 14.599609 26.099609 15 26.600781 15.5 27.300781 C 16 28.000781 16.699609 28.800781 17.599609 29.800781 C 19.399609 31.700781 21.899609 33.899219 25.099609 35.199219 C 26.499609 35.799219 27.699609 36.2 28.599609 36.5 C 30.199609 37 31.700781 36.900781 32.800781 36.800781 C 33.600781 36.700781 34.500391 36.299219 35.400391 35.699219 C 36.300391 35.099219 37.199609 34.400391 37.599609 33.400391 C 37.899609 32.600391 37.999609 31.900781 38.099609 31.300781 L 38.099609 30.5 C 38.099609 30.2 38.000781 30.200781 37.800781 29.800781 C 37.300781 29.000781 36.799219 29.000781 36.199219 28.800781 C 35.899219 28.600781 34.999219 28.200781 34.199219 27.800781 C 33.299219 27.400781 32.599609 27.000781 32.099609 26.800781 C 31.799609 26.700781 31.400391 26.499609 30.900391 26.599609 C 30.400391 26.699609 29.899609 27 29.599609 27.5 C 29.299609 27.9 28.200781 29.299219 27.800781 29.699219 L 27.699219 29.599609 C 27.299219 29.399609 26.7 29.200781 26 28.800781 C 25.2 28.400781 24.299219 27.800781 23.199219 26.800781 C 21.599219 25.400781 20.499219 23.699609 20.199219 23.099609 C 20.499219 22.699609 20.899609 22.3 21.099609 22 C 21.199609 21.9 21.280859 21.799219 21.349609 21.699219 C 21.418359 21.599219 21.475391 21.500391 21.525391 21.400391 C 21.625391 21.200391 21.700781 21.000781 21.800781 20.800781 C 22.200781 20.100781 22.000781 19.300391 21.800781 18.900391 C 21.800781 18.900391 21.7 18.600781 21.5 18.300781 C 21.4 18.000781 21.2 17.499609 21 17.099609 C 20.6 16.199609 20.2 15.199609 20 14.599609 C 19.7 13.899609 19.300781 13.399219 18.800781 13.199219 C 18.550781 13.049219 18.300781 13.000781 18.113281 12.988281 z M 16.599609 15 L 17.699219 15 L 17.900391 15 C 17.900391 15 17.999609 15.100391 18.099609 15.400391 C 18.299609 16.000391 18.799609 17.000391 19.099609 17.900391 C 19.299609 18.300391 19.499609 18.799609 19.599609 19.099609 C 19.699609 19.399609 19.800391 19.600781 19.900391 19.800781 C 19.900391 19.900781 20 19.900391 20 19.900391 C 19.8 20.300391 19.8 20.399219 19.5 20.699219 C 19.2 21.099219 18.799219 21.499219 18.699219 21.699219 C 18.599219 21.899219 18.299609 22.1 18.099609 22.5 C 17.899609 22.9 18.000781 23.599609 18.300781 24.099609 C 18.700781 24.699609 19.900781 26.700391 21.800781 28.400391 C 23.000781 29.500391 24.1 30.199609 25 30.599609 C 25.9 31.099609 26.600781 31.300391 26.800781 31.400391 C 27.200781 31.600391 27.599609 31.699219 28.099609 31.699219 C 28.599609 31.699219 29.000781 31.3 29.300781 31 C 29.700781 30.6 30.699219 29.399609 31.199219 28.599609 L 31.400391 28.699219 C 31.400391 28.699219 31.699609 28.8 32.099609 29 C 32.499609 29.2 32.900391 29.399609 33.400391 29.599609 C 34.300391 29.999609 35.100391 30.399609 35.400391 30.599609 L 36 30.900391 L 36 31.199219 C 36 31.599219 35.899219 32.200781 35.699219 32.800781 C 35.599219 33.100781 35.000391 33.699609 34.400391 34.099609 C 33.700391 34.499609 32.899609 34.800391 32.599609 34.900391 C 31.699609 35.000391 30.600781 35.099219 29.300781 34.699219 C 28.500781 34.399219 27.4 34.1 26 33.5 C 23.2 32.3 20.899219 30.3 19.199219 28.5 C 18.399219 27.6 17.699219 26.799219 17.199219 26.199219 C 16.699219 25.599219 16.500781 25.2 16.300781 25 C 15.900781 24.6 14 21.999609 14 19.599609 C 14 17.099609 15.200781 16.100391 15.800781 15.400391 C 16.100781 15.000391 16.499609 15 16.599609 15 z"></path>
    </svg>`,
    whatsappv1: `<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewbox="0 0 50 50">
    <path fill="currentColor" d="M 25 2 C 12.318 2 2 12.318 2 25 C 2 28.96 3.0228906 32.853062 4.9628906 36.289062 L 2.0371094 46.730469 C 1.9411094 47.073469 2.03325 47.440312 2.28125 47.695312 C 2.47225 47.892313 2.733 48 3 48 C 3.08 48 3.1612344 47.989703 3.2402344 47.970703 L 14.136719 45.271484 C 17.463719 47.057484 21.21 48 25 48 C 37.682 48 48 37.682 48 25 C 48 12.318 37.682 2 25 2 z M 16.642578 14 C 17.036578 14 17.428437 14.005484 17.773438 14.021484 C 18.136437 14.039484 18.624516 13.883484 19.103516 15.021484 C 19.595516 16.189484 20.775875 19.058563 20.921875 19.351562 C 21.069875 19.643563 21.168656 19.984047 20.972656 20.373047 C 20.776656 20.762047 20.678813 21.006656 20.382812 21.347656 C 20.086813 21.688656 19.762094 22.107141 19.496094 22.369141 C 19.200094 22.660141 18.892328 22.974594 19.236328 23.558594 C 19.580328 24.142594 20.765484 26.051656 22.521484 27.597656 C 24.776484 29.583656 26.679531 30.200188 27.269531 30.492188 C 27.859531 30.784188 28.204828 30.734703 28.548828 30.345703 C 28.892828 29.955703 30.024969 28.643547 30.417969 28.060547 C 30.810969 27.477547 31.204094 27.572578 31.746094 27.767578 C 32.288094 27.961578 35.19125 29.372062 35.78125 29.664062 C 36.37125 29.956063 36.766062 30.102703 36.914062 30.345703 C 37.062062 30.587703 37.062312 31.754234 36.570312 33.115234 C 36.078313 34.477234 33.717984 35.721672 32.583984 35.888672 C 31.565984 36.037672 30.277281 36.10025 28.863281 35.65625 C 28.006281 35.38625 26.907047 35.028734 25.498047 34.427734 C 19.575047 31.901734 15.706156 26.012047 15.410156 25.623047 C 15.115156 25.234047 13 22.46275 13 19.59375 C 13 16.72475 14.524406 15.314469 15.066406 14.730469 C 15.608406 14.146469 16.248578 14 16.642578 14 z"></path>
    </svg>`
};

const inputs = {
    buttonText: document.getElementById('buttonText'),
    brandColorPicker: document.getElementById('brandColorPicker'),
    bgImage: document.getElementById('backgroundImageUrl'),
    brandColorText: document.getElementById('brandColorText'),
    chatButtonColorPicker: document.getElementById('chatButtonColorPicker'),
    chatButtonColorText: document.getElementById('chatButtonColorText'),
    brandName: document.getElementById('brandName'),
    whatsappNumber: document.getElementById('whatsappNumber'),
    brandImageUrl: document.getElementById('brandImageUrl'),
    welcomeMessage: document.getElementById('welcomeMessage'),
    prefilledMessage: document.getElementById('prefilledMessage'),
};
const preview = {
    floatButton: document.getElementById('preview-float-button'),
    icon: document.getElementById('preview-icon'),
    widget: {
        header: document.getElementById('preview-widget-header'),
        logo: document.getElementById('preview-widget-logo'),
        brand: document.getElementById('preview-widget-brand'),
        message: document.getElementById('preview-widget-message'),
        button: document.getElementById('preview-widget-button'),
    }
};

const output = {
    code: document.getElementById('generated-code'),
    generateBtn: document.getElementById('generateBtn'),
    copyBtn: document.getElementById('copyCodeBtn'),
};

// Populate icon selectors
const iconSelector = document.getElementById('chatButtonIconGroup');
Object.keys(icons).forEach(key => {
    const label = iconSelector.querySelector(`input[value="${key}"]`).parentElement;
    const span = label.querySelector('.icon-option');
    if(span) span.innerHTML = icons[key];
});

inputs.brandColorPicker.addEventListener('input', (e) => { inputs.brandColorText.value = e.target.value; updateAll(); });
inputs.brandColorText.addEventListener('input', (e) => { inputs.brandColorPicker.value = e.target.value; updateAll(); });
inputs.chatButtonColorPicker.addEventListener('input', (e) => { inputs.chatButtonColorText.value = e.target.value; updateAll(); });
inputs.chatButtonColorText.addEventListener('input', (e) => { inputs.chatButtonColorPicker.value = e.target.value; updateAll(); });

function sanitizeHTML(str) {
    const temp = document.createElement('div');
    temp.textContent = str;
    return temp.innerHTML;
}


inputs.bgImage.addEventListener('input', updateAll);


function updateAll() {
    const imageUrl = inputs.bgImage.value.trim();
    const previewWidget = document.getElementById('preview-widget-body');
        if (imageUrl) {
            previewWidget.style.backgroundImage = `url('${imageUrl}')`;
            previewWidget.style.backgroundSize = 'cover';
            previewWidget.style.backgroundPosition = 'center';
            previewWidget.style.backgroundRepeat = 'no-repeat';
        } else {
            previewWidget.style.backgroundImage = '';
        }
    const brandColor = inputs.brandColorText.value;
    const iconColor = inputs.chatButtonColorText.value;
    const position = document.querySelector('input[name="buttonPosition"]:checked').value;
    const iconKey = document.querySelector('input[name="chatButtonIcon"]:checked').value;
    const icon = icons[iconKey];
    const brandName = inputs.brandName.value;
    const logoUrl = inputs.brandImageUrl.value || `https://ui-avatars.com/api/?name=${encodeURIComponent(brandName)}&background=random&color=fff&font-size=0.5`;
    const bgImage = inputs.bgImage.value;
    preview.floatButton.style.backgroundColor = brandColor;
    preview.floatButton.style.color = iconColor;
    preview.floatButton.className = 'preview-float-button'; 
    preview.floatButton.classList.add(position);
    preview.icon.innerHTML = icon;
    preview.widget.message.style.backgroundImage = bgImage;
    preview.widget.message.style.backgroundSize = 'cover';
    preview.widget.message.style.backgroundPosition = 'center';
    preview.widget.message.style.backgroundRepeat = 'no-repeat';
    preview.widget.header.style.backgroundColor = brandColor;
    preview.widget.logo.src = logoUrl;
    preview.widget.brand.textContent = brandName;
    preview.widget.message.textContent = inputs.welcomeMessage.value;
    preview.widget.button.textContent = inputs.buttonText.value;
    preview.widget.button.style.backgroundColor = brandColor;

    generateCode();
}

function generateCode() {
    const siteurl = window.location.protocol + '//' + window.location.hostname;
    const values = {
        btnText: sanitizeHTML(inputs.buttonText.value),
        brandColor: sanitizeHTML(inputs.brandColorText.value),
        bgImage: sanitizeHTML(inputs.bgImage.value),
        iconColor: sanitizeHTML(inputs.chatButtonColorText.value),
        position: sanitizeHTML(document.querySelector('input[name="buttonPosition"]:checked').value),
        positionCss: document.querySelector('input[name="buttonPosition"]:checked').value === 'bottom-left' ? 'left: 20px;' : 'right: 20px;',
        iconSvg: icons[document.querySelector('input[name="chatButtonIcon"]:checked').value],
        brand: sanitizeHTML(inputs.brandName.value),
        waNumber: sanitizeHTML(inputs.whatsappNumber.value.replace(/[^0-9]/g, '')),
        logoUrl: sanitizeHTML(inputs.brandImageUrl.value) || `https://ui-avatars.com/api/?name=${encodeURIComponent(inputs.brandName.value)}&background=random&color=fff&font-size=0.5`,
        welcomeMsg: sanitizeHTML(inputs.welcomeMessage.value).replace(/\n/g, '<br>'),
        prefilledMsg: encodeURIComponent(inputs.prefilledMessage.value),
    };                
    if (!values.waNumber) {
        output.code.value = "<!-- Please enter a valid WhatsApp Number to generate the code. -->";
        return;
    }
const finalCode = `<!-- Start WhatsApp Chat Button Generated by Tool -->
<style>
.wa-chat-container { 
position: fixed; bottom: 20px; ${values.positionCss} z-index: 1000; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
}
.wa-float-button {
background-color: ${values.brandColor}!important; color: ${values.iconColor}!important; width: 60px; height: 60px; border-radius: 50%; border: none; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 4px 12px rgba(0,0,0,0.2); transition: transform 0.2s ease, box-shadow 0.2s ease;padding:0!important;
}
.wa-float-button:hover {
transform: scale(1.1); box-shadow: 0 6px 16px rgba(0,0,0,0.3); 
}
.wa-float-button svg { width: 32px; height: 32px; }
.wa-chat-widget { 
background:#fff; border-radius: 10px; box-shadow: 0 5px 20px rgba(0,0,0,0.15); width: 340px; max-width: 90vw; position: absolute; bottom: calc(100% + 15px); ${values.position === 'bottom-left' ? 'left: 0;' : 'right: 0;'} display: flex; flex-direction: column; overflow: hidden; opacity: 0; transform: translateY(10px) scale(0.95); visibility: hidden; transition: opacity 0.3s ease, transform 0.3s ease, visibility 0.3s; transform-origin: ${values.position === 'bottom-left' ? 'bottom left' : 'bottom right'};/*min-height:320px;*/
}
.wa-chat-widget.active { opacity: 1; transform: translateY(0) scale(1); visibility: visible; }
.wa-widget-header {
background-color: ${values.brandColor}; color: ${values.iconColor}; padding: 16px; display: flex; align-items: center; gap: 12px;
}
.wa-widget-header img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; }
.wa-brand-name { font-size: 1.1rem; font-weight: 700; color: ${values.iconColor}; }
.wa-widget-close { margin-left: auto; background: none!important; border: none!important; color: ${values.iconColor}!important; font-size: 24px!important; line-height: 1; cursor: pointer; opacity: 0.8; transition: opacity 0.2s, transform 0.2s;box-shadow: none;padding:0!important; }
.wa-widget-close:hover { opacity: 1; transform: rotate(90deg); }
.wa-widget-body { background: ${values.bgImage === '' ? `url('${siteurl}/images/whatsapp-bg.png')`: `url('${values.bgImage}')`}; padding: 16px;min-height:120px; }
.wa-widget-body-message { background-color: #fff; border-radius: 8px; padding: 12px; font-size: 14.5px; line-height: 1.5; margin: 0; display: inline-block; box-shadow: 0 1px 1px rgba(0,0,0,0.05); }
.wa-widget-footer { padding: 16px; /* background-color: #fff; border-top: 1px solid #f0f0f0;*/ }
.wa-widget-footer a { background-color: ${values.brandColor}; color: #fff; text-decoration: none; padding: 12px 20px; border-radius: 8px; font-size: 1rem; font-weight: 600; display: block; text-align: center; transition: opacity 0.2s; }
.wa-widget-footer a:hover { opacity: 0.9; }
</style>
<div class="wa-chat-container">
<div class="wa-chat-widget">
<div class="wa-widget-header">
    <img src="${values.logoUrl}" alt="${values.brand} Logo" onerror="this.onerror=null;this.src='https://ui-avatars.com/api/?name=${encodeURIComponent(values.brand)}&background=random&color=fff&font-size=0.5';">
    <span class="wa-brand-name">${values.brand}</span>
    <button class="wa-widget-close" aria-label="Close Chat">&times;</button>
</div>
<div class="wa-widget-body">
    <p class="wa-widget-body-message">${values.welcomeMsg}</p>
</div>
<div class="wa-widget-footer">
    <a href="https://wa.me/${values.waNumber}?text=${values.prefilledMsg}" target="_blank" rel="noopener noreferrer">${values.btnText}</a>
</div>
</div>
<button class="wa-float-button" aria-label="Open WhatsApp Chat">
${values.iconSvg}
</button>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
const waContainer = document.querySelector('.wa-chat-container');
if (waContainer) {
    const openButton = waContainer.querySelector('.wa-float-button');
    const chatWidget = waContainer.querySelector('.wa-chat-widget');
    const closeButton = waContainer.querySelector('.wa-widget-close');
    if (!openButton || !chatWidget || !closeButton) return;

    const toggleWidget = (e) => { e.stopPropagation(); chatWidget.classList.toggle('active'); };
    const closeWidget = () => chatWidget.classList.remove('active');

    openButton.addEventListener('click', toggleWidget);
    closeButton.addEventListener('click', closeWidget);
    
    document.addEventListener('click', (e) => { if (!waContainer.contains(e.target) && chatWidget.classList.contains('active')) closeWidget(); });
    document.addEventListener('keydown', (e) => { if (e.key === 'Escape' && chatWidget.classList.contains('active')) closeWidget(); });
}
});
<\/script>
<!-- End WhatsApp Chat Button -->`;
        output.generateBtn.addEventListener('click', function() {
            output.code.value = finalCode;
            document.getElementById('genrated-code-box').style.display = 'block';
        })
    }
    form.addEventListener('input', updateAll);
    output.copyBtn.addEventListener('click', () => {
        output.code.select();
        try {
            document.execCommand('copy');
            output.copyBtn.textContent = 'Copied!';
        } catch (err) {
            output.copyBtn.textContent = 'Error!';
        }
        setTimeout(() => {
            output.copyBtn.textContent = 'Copy Code';
        }, 2000);
    });
    updateAll();
})();
const accordionHeaders = document.querySelectorAll(".accordion-header");
accordionHeaders.forEach(header => {
header.addEventListener("click", () => {
    const siblings = Array.from(header.parentElement.children).filter(el => el !== header);
    siblings.forEach(sibling => sibling.classList.remove("is-open"));
    header.classList.toggle("is-open");
});
});
const buttonGroup = document.getElementById('buttonPositionGroup');
const floatingIcon = document.getElementById('preview-float-button');
buttonGroup.addEventListener('change', (event) => {
if (event.target.name === 'buttonPosition') {
    const selectedPosition = event.target.value;
    // Remove existing position classes
    floatingIcon.classList.remove('bottom-right', 'bottom-left');
    // Add selected position
    floatingIcon.classList.add(selectedPosition);
}
});
</script>
    <?php
    return ob_get_clean();
}
?>
