<?php 
add_action('init', 'create_posttype');
add_action('add_meta_boxes','add_meta_boxes_joomcast');
//add_action('add_meta_boxes','add_meta_boxes_ourguest');
add_action('save_post','handle_custom_field');
add_shortcode('jd_listen_audio', 'jd_listen_audio_joomcast');
add_shortcode('guestimage', 'jd_get_guest_image_joomcast');
//add_action('save_post','our_guest_post_meta_data');
//add_action('manage_jd-ourguest_posts_custom_column', 'show_thumbnail_column_jd_ourguest', 10, 2);
//add_filter('manage_jd-ourguest_posts_columns', 'add_thumbnail_column_jd_ourguest');

function create_posttype()
{
register_post_type(
'services',
array(
'labels' => array(
	'name' => __('Services'),
	'singular_name' => __('Services'),
	'view_item' => __('View Services '),
	'add_new_item' => __('Add New service'),
	'add_new' => __('Add New service'),
	'new_item' => __('New service'),
	'edit_item' => __('Edit service'),
	'update_item' => __('Update service'),
	'search_items' => __('Search service'),
	'not_found' => __('Not Found'),
	'not_found_in_trash' => __('Not found in Trash'),
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'rewrite' => array('slug' => 'services'),
'supports' => array('thumbnail', 'title', 'editor'),
)
);
register_post_type(
'solutions',
array(
'labels' => array(
	'name' => __('Solutions'),
	'singular_name' => __('Solutions'),
	'view_item' => __('View Solutions '),
	'add_new_item' => __('Add New solution'),
	'add_new' => __('Add New solution'),
	'new_item' => __('New solution'),
	'edit_item' => __('Edit solution'),
	'update_item' => __('Update solution'),
	'search_items' => __('Search solution'),
	'not_found' => __('Not Found'),
	'not_found_in_trash' => __('Not found in Trash'),
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'rewrite' => array('slug' => 'solutions'),
)
);
register_post_type(
'tools',
array(
'labels' => array(
	'name' => __('Tools'),
	'singular_name' => __('Tools'),
	'view_item' => __('View Tools '),
	'add_new_item' => __('Add New Tools'),
	'add_new' => __('Add New Tools'),
	'new_item' => __('New Tools'),
	'edit_item' => __('Edit Tools'),
	'update_item' => __('Update Tools'),
	'search_items' => __('Search Tools'),
	'not_found' => __('Not Found'),
	'not_found_in_trash' => __('Not found in Trash'),
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'rewrite' => array('slug' => 'tools'),
'supports' => array('thumbnail', 'title', 'editor'),
)
);
register_post_type(
'jd-joomcast',
array(
'labels' => array(
	'name' => __('Joomcast'),
	'singular_name' => __('Joomcast'),
	'view_item' => __('View Joomcast '),
	'add_new_item' => __('Add New Joomcast'),
	'add_new' => __('Add New Joomcast'),
	'new_item' => __('New Joomcast'),
	'edit_item' => __('Edit Joomcast'),
	'update_item' => __('Update Joomcast'),
	'search_items' => __('Search Joomcast'),
	'not_found' => __('Not Found'),
	'not_found_in_trash' => __('Not found in Trash'),
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'rewrite' => array('slug' => 'joomcast'),
'supports' => array('thumbnail', 'title', 'editor', 'custom-fields','author'),
)
);
/*register_post_type(
'jd-ourguest',
array(
'labels' => array(
	'name' => __('Our Guest'),
	'singular_name' => __('Our Guest'),
	'view_item' => __('View Our Guest '),
	'add_new_item' => __('Add New Our Guest'),
	'add_new' => __('Add New Our Guest'),
	'new_item' => __('New Guest'),
	'edit_item' => __('Edit Guest'),
	'update_item' => __('Update Guest'),
	'search_items' => __('Search Guest'),
	'not_found' => __('Not Found'),
	'not_found_in_trash' => __('Not found in Trash'),
),
'public' => true,
'has_archive' => true,
'show_in_rest' => true,
'rewrite' => array('slug' => 'our-guest'),
'supports' => array('thumbnail', 'title', 'editor'),
)
);*/
}



function add_meta_boxes_joomcast(){  // custom feils for joomcast post type stackoverflow
     add_meta_box(
         'joomcast',
         'JoomDev Joomcast',
         'add_meta_boxes_joomcast_fields',
         'jd-joomcast',
         'normal',
         'low'

     );
 }
 /*function add_meta_boxes_ourguest(){  // custom feils for jd-ourguest post type stackoverflow
     add_meta_box(
         'ourguest',
         'Our Guest',
         'add_meta_boxes_ourguest_fields',
         'jd-ourguest',
         'normal',
         'low'

     );
 }*/

 
 function add_meta_boxes_joomcast_fields($post){
     $episodeNumber = get_post_meta($post->ID,'jd_podcast_episode_number',true);
     $hostName = get_post_meta($post->ID,'jd_podcast_host_person',true);
     $videourl = get_post_meta($post->ID,'jd_podcast_video_url',true);
     $seasonNumber = get_post_meta($post->ID,'jd_podcast_season_number',true);
     $audiospotify = get_post_meta($post->ID,'jd_audio_embeded_code',true);
     $guestname = get_post_meta($post->ID,'jd_our_guest_name',true);
     $image_id = get_post_meta($post->ID, 'our_guest_image_id', true);
     $image_url = $image_id ? wp_get_attachment_url($image_id) : '';
     $guestdesignation = get_post_meta($post->ID, 'our_guest_designation', true);
     $guestdescription = get_post_meta($post->ID,'our_guest_description',true);
     $transcript = get_post_meta($post->ID,'jd_joomcast_transcript',true);
   
     wp_nonce_field( 'postcast_inner_custom_box', 'postcast_inner_custom_box_nonce' );
     ?>
     <table class="podcast-fields" width="100%" border="0">
     <tr>
     <td>
     <hr/>
     <h3>Joomcast video</h3>
        <label for = "episode"><strong>Episode No. : </strong></label></strong><br>
    	 <input type ="text" name="episodeno" value="<?php echo $episodeNumber; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
     <tr>
     <td>
        <strong><label for = "contact-person">Host Name : </label></strong><br>
     <input type ="text" name="hostname" value="<?php echo $hostName; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
     <tr>
     <td>
        <label for = "videourl"><strong> Video Url : </strong></label><br>
     	<input type ="text" name="videourl" value="<?php echo $videourl ? $videourl : '#' ;?>" style="width:90%;"><br><br>
     </td>
     <tr>
     <td>
     <hr/>
     <h3>Season Number</h3>
        <label for = "episode"><strong>Season Number. : </strong></label></strong><br>
    	 <input type ="text" name="seasonNumber" value="<?php echo $seasonNumber; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
     </tr>
      <tr>
     <td>
        <hr/>
        <h3>Listen Audio</h3>
     </td>
     </tr>
      <tr>
     <td>
        <label for = "audio-spotify"><strong>Spotify embedded code  : </strong></label><br>
        <input type ="text" name="audiospotify" value="<?php echo $audiospotify; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
       <tr>
     <td>
     	<hr/>
        <h3>Our Guest</h3>
        <label for = "guestname"><strong>Guest Name : </strong></label></strong><br>
    	<input type ="text" name="guestname" value="<?php echo $guestname; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
       <tr>
     <td>
        <label for = "guestthumbnails"><strong>Guest thumbnails: </strong></label></strong><br>
    	<img id="guestavatarpreview" src="<?php echo esc_url($image_url); ?>" style="max-width:30%;<?php echo $image_url ? '' : 'display:none;'; ?>" />
        <input type="hidden" name="guestavatar" id="guestavatarId" value="<?php echo esc_attr($image_id); ?>" />
        <br>
        <button type="button" class="button" id="guestavatarupload">Upload Image</button>
        <button type="button" class="button" id="guestavatarremove" <?php echo $image_url ? '' : 'style="display:none;"'; ?>>Remove</button>
     </td>
     </tr>
     <tr>
     <td>
        <label for = "guestdesignation"><strong>Guest Designation : </strong></label></strong><br>
    	<input type ="text" name="guestdesignation" value="<?php echo $guestdesignation; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
     <tr>
     <td>
        <label for = "guestdesignation"><strong>Guest Description : </strong></label></strong><br>
    	<?php wp_editor( $guestdescription, 'guestdescription', array(
        'textarea_name' => 'guestdescription', // Name for the textarea
    	) );?>
     </td>
     </tr>
      <tr>
     <td>
     	<hr/>
        <h3>Transcript</h3>
        <!--<label for = "transcript"><strong>Transcript : </strong></label><br>-->
        <?php wp_editor( $transcript, 'transcript', array(
        'textarea_name' => 'transcript', // Name for the textarea
    ) );?>
     </td>
     </tr>
     </table>	
     <?php
 }

 function handle_custom_field($post_id){
     /*if(isset($_POST['postcast_inner_custom_box_nonce'])){
        return ;
     }*/
     if(!empty($_POST['episodeno'])){
         $episodeno = $_POST['episodeno'];
     }else{
    	 $episodeno = '';
     }
     if(!empty($_POST['hostname'])){
         $hostName = $_POST['hostname'];
     }else{
    	 $hostName = '';
     }
     if(!empty($_POST['seasonNumber'])){
     	$seasonNumber = $_POST['seasonNumber'];
     }else{
    	 $seasonNumber = '';
     }
     if(!empty($_POST['videourl'])){
        $videourl = $_POST['videourl']; 
    }else{
     	$videourl = '#';
    }
    if(!empty($_POST['audiospotify'])){
        $audiospotify = $_POST['audiospotify'];
    }else{
    	$audiospotify = '';
    }
    if(!empty($_POST['guestname'])){
        $guestname = $_POST['guestname'];
    }else{
   	$guestname = '';
    }
    if(!empty($_POST['guestavatar'])){
        $guestavatar = $_POST['guestavatar'];
        
    }else{
    	$guestavatar = '';
    }
    if(!empty($_POST['guestdesignation'])){
        $guestdesignation = $_POST['guestdesignation'];   
    }else{
    	$guestdesignation = '';
    }
    if(!empty($_POST['guestdescription'])){
        $guestdescription = $_POST['guestdescription'];    
    }else{
    	$guestdescription = '';
    }
    if(!empty($_POST['transcript'])){
        $transcript = $_POST['transcript'];    
    }else{
    	$transcript = '';
    }
    update_post_meta($post_id,'jd_podcast_episode_number', $episodeno);
    update_post_meta($post_id,'jd_podcast_host_person',$hostName);
    update_post_meta($post_id,'jd_podcast_season_number',$seasonNumber);
    update_post_meta($post_id,'jd_podcast_video_url',$videourl);
    update_post_meta($post_id,'jd_audio_embeded_code',$audiospotify);
    update_post_meta($post_id,'jd_our_guest_name',$guestname);
    update_post_meta($post_id,'our_guest_image_id',$guestavatar);
    update_post_meta($post_id,'our_guest_designation',$guestdesignation);
    update_post_meta($post_id,'our_guest_description',$guestdescription);
    update_post_meta($post_id,'jd_joomcast_transcript',$transcript);
   
    
 }
 
function jd_listen_audio_joomcast($attr){
     ob_start();
    $id = get_the_ID();
    $audio_embed = get_post_meta($id, 'jd_audio_embeded_code', true);
    if (!empty($audio_embed)) {
            echo '<iframe data-testid="embed-iframe" style="border-radius:12px" src="' . esc_url(trim($audio_embed)) . '" width="100%" height="352" frameBorder="0" allowfullscreen="" allow="autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture" loading="lazy"></iframe>';
    }
    return ob_get_clean();
}

function jd_get_guest_image_joomcast($attr){
    ob_start();
    $id = get_the_ID();
    $image_id = get_post_meta($id, 'our_guest_image_id', true);
    $image = wp_get_attachment_image($image_id, 'full');
    echo $image; 
    return ob_get_clean();
}



/* function add_meta_boxes_ourguest_fields($post){
   $designation = get_post_meta($post->ID,'_jd_guest_designation',true);
   wp_nonce_field( 'postcast_inner_guest_box', 'postcast_inner_guest_box_nonce' );
   ?>
   <table class="podcast-fields" width="100%" border="0">
     <tr>
     <td>
     <hr/>
     <h3>Guest designation</h3>
     <strong><label for = "designation">Designation: </label></strong><br>
    	 <input type ="text" name="designation" value="<?php echo $designation; ?>" style="width:90%;"><br><br>
     </td>
     </tr>
   </table>
   <?php 	
 }
 function our_guest_post_meta_data($post){
 	if($_POST['designation']){
         $designation = $_POST['designation'];
         update_post_meta($post_id, '_jd_guest_designation', $designation);
     	}
 
 }
 
 function add_thumbnail_column_jd_ourguest($columns) {
    // Insert thumbnail column after checkbox
    $new = [];
    foreach ($columns as $key => $value) {
        $new[$key] = $value;
        if ($key == 'cb') {
            $new['thumbnail'] = __('Image');
        }
    }
    return $new;
}

function show_thumbnail_column_jd_ourguest($column, $post_id) {
    if ($column === 'thumbnail') {
        echo get_the_post_thumbnail($post_id, [100, 100]); // Thumbnail size
    }
}*/

?>