<?php 
/* Plugin name: misc customization
* Description: misc customization
* Version: 1.0.0
* Author: joomDev
* Author URI: https://joomdev.com/
*/
define( 'MISCPLUGINPATH', plugin_dir_path( __FILE__ ) );
include_once MISCPLUGINPATH .'misc-post-types.php';
include_once MISCPLUGINPATH .'misc-whatsapp-icon.php';
include_once MISCPLUGINPATH .'misc-crm-roi-calculator.php';
function wp_misc_customizaton_slider_scripts(){	
	wp_register_script( 'misc-scripts-js', plugins_url('/assets/js/misc-scripts.js', __FILE__),	array(), '1.1.2', true );	
	wp_register_script( 'joomdev-blog-js', plugins_url('/assets/js/blog.js', __FILE__),	array(), '1.7.8', true );
	wp_register_script( 'jd-chart-js', 'https://cdn.jsdelivr.net/npm/chart.js',	array(), '1.6.8', false );
	wp_register_script( 'jd-tailwindcss', 'https://cdn.tailwindcss.com', array(), '1.6.8', true );
    wp_register_style( 'misc-style-css',	plugins_url('/assets/css/misc-style.css', __FILE__),	false, '1.1.5', 'all');
	wp_register_style( 'joomdev-blog-css', plugins_url('/assets/css/blogs.css', __FILE__),	false, '', 'all');
    wp_register_style( 'jd-whatsapp-css', plugins_url('/assets/css/whatsapp.css', __FILE__),	false, '2.0.7', 'all');
    wp_register_style( 'jd-crmroi-css', plugins_url('/assets/css/crm-roi-calc.css', __FILE__),	false, '1.0.0', 'all');
	wp_enqueue_style( 'misc-style-css');
	wp_enqueue_style( 'joomdev-blog-css');
	wp_enqueue_script('misc-scripts-js');
	wp_enqueue_script('joomdev-blog-js');
    
}
add_action('admin_enqueue_scripts', function($hook){
    global $post;
    if (($hook === 'post-new.php' || $hook === 'post.php') && $post->post_type === 'jd-joomcast') {
        wp_enqueue_media();
        wp_enqueue_script('guest-meta-box-media', plugins_url('/assets/js/guest-box-media.js', __FILE__), ['jquery'], null, true);
    }
});


function generate_random_number($value){
   return mt_rand(100000, 999999);
}
function show_and_hide_forms(){
	$getFormentry = @$_GET['lid'];
	if($getFormentry){
		$html = '<style>.validate-otp{display:block;}.zapier-validate{display:none;}</style>';
	}else{
		$html = '<style>.validate-otp{display:none;}.zapier-validate{display:block;}</style>';
	}
	echo $html;
}
function check_and_validate_otp( $result, $value, $form, $field ){
	$entry_id = $_GET['lid'];
	$entry = GFAPI::get_entry( $entry_id );
	$userotp = $entry['7'];
	if( $result['is_valid'] && intval( $value ) != $userotp ){ 
		$result['is_valid'] = false;
		$result['message'] = 'Invalid OTP'; 
	}
	return $result;
}

/* function update_otpcheck_value_in_input_field($entry, $form){
    global $wpdb;
		echo $id = $entry['id'];
		echo $lidID = $entry['4'];
		$formID = 1;
		if($lidID){
			$result = GFAPI::update_entry_field( $lidID, $input_id, $value );
		}
		
		echo '</pre>';print_r($entry);echo '</pre>';
		

}*/
//add_action("gform_after_submission_2", "update_otpcheck_value_in_input_field", 10, 2); 
add_action( 'widgets_init', 'twentyten_widgets_init' );
function twentyten_widgets_init() {
  register_sidebar( array(
    'name' => __( 'Blog page sidebar', 'mighty' ),
    'id' => 'blog-page-sidebar',
    'description' => __( 'The Blog Sidebar Area', 'mighty' ),
    'before_widget' => '<div id="%1$s" class="widget-container %2$s">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
  ));
}
add_filter("gform_field_value_otp", "generate_random_number");
add_filter("gform_field_validation_2_3", "check_and_validate_otp", 10, 4 );
add_filter("wp_footer", "show_and_hide_forms");
add_action( 'wp_enqueue_scripts', 'wp_misc_customizaton_slider_scripts' );

function table_of_content( $atts = array() )
{
	$post_type = get_post_type();
	$postID = get_the_ID();
    extract(shortcode_atts(array(
        'title' => "",
    ), $atts ) );
	if ($post_type == 'page') {
		return;
	}
	return generate_table_of_content( get_the_content($postID), $atts );
}
add_shortcode('toc', 'table_of_content');
function generate_table_of_content( $HTML, $title ) {
	if( !empty ( $title ) ) {
		$post_title = $title['title'];
	} else {
		$post_title = get_the_title();
	}
    $DOM = new DOMDocument();
    libxml_use_internal_errors( true );
	 if(empty($HTML)){
		return;
	 }
	$DOM->loadHTML( $HTML );
    libxml_clear_errors();
    $navigation = '<div class="table-content-new"><h3 class="table-content-new__header"><span>'. html_entity_decode( $post_title ) .'</span></h3><ol class="table-content-new__body navigation-list">';
    // Iterating through all elements
    $h2IteratorStatus = 0; //0-closed, 1-open
    $h3IteratorStatus = 0; //0-closed, 1-open
    foreach( $DOM->getElementsByTagName( '*' ) as $element ) {
        //echo '</pre>';print_r($element);echo '</pre>';
            if( $element->tagName == 'h2' ) {
            if( $h3IteratorStatus ){
                //it's open, need to close
                $navigation .= '</ol>';
                $h3IteratorStatus = 0;
            }
            if( $h2IteratorStatus ){
                //it's open, need to close
                $navigation .= '</li>';
                $h2IteratorStatus = 0;
            }
            $h2IteratorStatus = 1;
            $navigation .= '<li class="navigation-items maindorpdown"><span><a class="parent" href="#'.$element->getAttribute("id").'">' . html_entity_decode( $element->textContent ) . '</a></span>';
        } else if ( $element->tagName == 'h3' ) {
            if( !$h3IteratorStatus ){
                $navigation .= '<ol>';
                $h3IteratorStatus = 1;
            }
            $navigation .= '<li class="navigation-items"><span><a href="#'.$element->getAttribute("id").'">' . html_entity_decode( $element->textContent ) .'</a></span></li>';
        }
    }
    //check for last opened h3
    if( $h3IteratorStatus ){
        $navigation .= '</ol>';
    }
    //check for last opened h2
    if( $h2IteratorStatus ){
        //it's open, need to close
        $navigation .= '</li>';
    }
    return $navigation.'</ol></div>';
}

add_filter( 'gform_field_css_class', 'hidden_field_css_class', 10, 3 );
function hidden_field_css_class( $classes, $field, $form ) {
	if( $field->type == 'hidden' ){
		$classes .= ' '.$field->inputName;
	}
	return $classes;
}

add_filter( 'gform_init_scripts_footer', '__return_false' ); // Prevent re-init scripts in popup
add_filter( 'gform_enqueue_scripts', function( $form, $is_ajax ) {
    if ( $is_ajax ) {
        wp_enqueue_script( 'gform_gravityforms' );
        wp_enqueue_style( 'gform_css' );
    }
    return $form;
}, 10, 2 );

add_action('astra_blog_archive_title_before', 'add_episode_number_on_archive');
function add_episode_number_on_archive(){
    $postJoomcast = get_queried_object();
    if($postJoomcast->name == 'jd-joomcast'){
        $postID = get_the_ID();
        $epiNumber = get_post_meta($postID, 'jd_podcast_episode_number', true);
        echo $html = '<div class="epi-num"><span class="meta-epi">Ep.</span>'.$epiNumber.'</div>';
    }
    return $html;
}

