<?php

if( ! class_exists('JdHikashopCategory') )
{
  include_once ( __DIR__ . '/helper.php' );
}

$articles = array_reduce( JdHikashopCategory::getCatList(), function ( $carry, $article ) {
  $carry[$article->category_id] = $article->category_name;
  return $carry;
}, [ ] );

return [
  'slug' => 'jd-JdHikashopCategory',
  'name' => 'JD Hikashop Category',
  'groups' => 'JoomDev',
  'form' => [
    'general' => [  
       [
        'name' => 'title',
        'type' => 'text',
        'value' => 'Development',
      ],   
      [ 
        'name' => 'title_tag',
        'type' => 'select',
        'value' => 'h4',
        'label' => 'Title Tag',
        'options' => [
            'h1'=> 'H1',
            'h2'=> 'H2',
            'h3'=> 'H3',
            'h4'=> 'H4',
            'h5'=> 'H5',
            'h6'=> 'H6',
            'div'=> 'DIV',
        ]            
      ], 
      [
        'name' => 'subtitle',
        'type' => 'text',
        'value' => 'Sub-title',
      ],  
      [ 
        'name' => 'subtitle_pos',
        'type' => 'select',
        'value' => 'After',
        'label' => 'Subtitle Position',
        'options' => [
            'After'=> 'After',
            'Before'=> 'Before',            
        ]  
      ], 
      [ 
        'name' => 'category',
        'type' => 'select',
        'label' => 'Select Category',
        'options' => $articles
      ],
      [
        'name' => 'display_products',
        'type' => 'text',
        'value' => '8',
      ], 
      [
        'name' => 'slides_count',
        'type' => 'slider',
        'label' => 'Slides To Show',
        'responsive' => true,
        'value' => '8',
      ],    

      [ 
        'name' => 'autoplay',
        'type' => 'switch',
        'label' => 'Auto Play',
        'value'=> true
      ],
      [ 
        'name' => 'autoplay_speed',
        'type' => 'text',
        'label' => 'Auto Play Speed',
        'value' => 5000,
        'depends' => [
          'autoplay' => true
        ]
      ],
      [ 
        'name' => 'dis_bullets',
        'type' => 'switch',
        'label' => 'Display Bullets',
        'value'=> true
      ],
      [ 
        'name' => 'dis_arrows',
        'type' => 'switch',
        'label' => 'Display Arrows',
        'value'=> true
      ],
      [ 
        'name' => 'new_arrival',
        'type' => 'switch',
        'label' => 'New Arrival',
        'value'=> true
      ],
      [ 
        'name' => 'hot_products',
        'type' => 'switch',
        'label' => 'Hot Products',
        'value'=> true
      ],
      [ 
        'name' => 'best_beller',
        'type' => 'switch',
        'label' => 'Best Seller',
        'value'=> true
      ],
    ],

    'styles' => [
      [
        'name' => 'title_styles',
        'type' => 'divider'
      ],

      [ 'name' => 'title_font',
        'type' => 'typography',
        'label' => 'Font'
      ],

      [ 'name' => 'title_color',
        'type' => 'color',
        'label' => 'Text Color'
      ],
      [
        'name' => 'sub_title_styles',
        'type' => 'divider'
      ],

      [ 'name' => 'sub_title_font',
        'type' => 'typography',
        'label' => 'Font'
      ],

      [ 'name' => 'sub_title_color',
        'type' => 'color',
        'label' => 'Text Color'
      ],

    ]
  ]
];
