<?php 
add_shortcode('crm_calculator', 'render_crm_calculator_widget');
function render_crm_calculator_widget() {
   ob_start();
//    wp_enqueue_script('jd-tailwindcss');
   wp_enqueue_script('jd-chart-js');
//    wp_enqueue_style( 'jd-crmroi-css');
?>
<style>
    /* Custom styles for a polished UI */
.main-container {
   background: white;
   border-radius: 24px;
   box-shadow: 0 20px 40px -15px rgba(0, 16, 203, 0.15);
   overflow: hidden;
}
.flex{
   display: flex;
}
.flex-wrap{
   flex-wrap: wrap
}
.justify-between{
   justify-content: space-between
}
.w-100{
   width: 100%;
}
.align-center{
   align-items: center;
}
.input-group {
   @apply flex items-center gap-4;
}
.input-field {
   max-width: 84px;
   text-align: center;
}
/* Chrome, Safari, Edge, Opera */
input::-webkit-outer-spin-button,
input::-webkit-inner-spin-button {
   -webkit-appearance: none;
   margin: 0;
}
/* Firefox */
input[type=number] {
   -moz-appearance: textfield;
}
input[type="range"]::-webkit-slider-runnable-track {
   box-shadow: none;
}
.range-slider {
   -webkit-appearance: none!important;
   appearance: none !important;
   width: 100% !important;
   height: 6px;
   background: #e0e7ff;
   border-radius: 3px;
   outline: none;
   opacity: 0.9;
   transition: opacity .2s;
   margin-bottom: 18px!important;
}
.range-slider:hover {
   opacity: 1;
}
.range-slider::-webkit-slider-thumb {
   -webkit-appearance: none;
   appearance: none;
   width: 22px;
   height: 22px;
   background:#14A269!important;
   cursor: pointer;
   border-radius: 50%;
   border: 0!important;
   box-shadow: none !important;
   transition: transform 0.2s ease;
}
.range-slider:active::-webkit-slider-thumb {
   transform: scale(1.1);
}
.range-slider::-moz-range-thumb {
   width: 22px;
   height: 22px;
   background:#14A269 !important;
   cursor: pointer;
   border-radius: 50% !important;
   border: 0!important;
   box-shadow: none !important;
}
/* Remove shadow from Firefox thumb */
.range-slider::-moz-range-thumb {
   box-shadow: none !important;
   border: none;
   outline: none;
}
/* Optional: Also remove focus styling if needed */
.range-slider:focus {
   box-shadow: none !important;
   outline: none !important;
}
.result-card {
   padding: 20px;
}
.result-value {
   font-size: 22px;
   font-weight: 700;
   font-family: 'Barlow';
}
.result-label {
   @apply text-base font-semibold text-gray-500;
}
.section-transition {
   transition: opacity 0.6s ease-in-out, transform 0.6s ease-in-out;
}
.modal-overlay {
   @apply fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center transition-opacity duration-300 z-50;
}
.crm-title{
   font-size: 38px;
   color: #2C397B;
}
@media(min-width:1023px){
.w-lg-48{
   width:48% !important;
}
}



/* tailwind */
 *, ::before, ::after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }/* ! tailwindcss v3.4.16 | MIT License | https://tailwindcss.com */*,::after,::before{box-sizing:border-box;border-width:0;border-style:solid;border-color:#e5e7eb}::after,::before{--tw-content:''}:host,html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;tab-size:4;font-family:ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";font-feature-settings:normal;font-variation-settings:normal;-webkit-tap-highlight-color:transparent}body{margin:0;line-height:inherit}hr{height:0;color:inherit;border-top-width:1px}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,pre,samp{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;font-feature-settings:normal;font-variation-settings:normal;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{text-indent:0;border-color:inherit;border-collapse:collapse}button,input,optgroup,select,textarea{font-family:inherit;font-feature-settings:inherit;font-variation-settings:inherit;font-size:100%;font-weight:inherit;line-height:inherit;letter-spacing:inherit;color:inherit;margin:0;padding:0}button,select{text-transform:none}button,input:where([type=button]),input:where([type=reset]),input:where([type=submit]){-webkit-appearance:button;background-color:transparent;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dd,dl,figure,h1,h2,h3,h4,h5,h6,hr,p,pre{margin:0}fieldset{margin:0;padding:0}legend{padding:0}menu,ol,ul{list-style:none;margin:0;padding:0}dialog{padding:0}textarea{resize:vertical}input::placeholder,textarea::placeholder{opacity:1;color:#9ca3af}[role=button],button{cursor:pointer}:disabled{cursor:default}audio,canvas,embed,iframe,img,object,svg,video{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}[hidden]:where(:not([hidden=until-found])){display:none}.mx-auto{margin-left:auto;margin-right:auto}.mb-10{margin-bottom:2.5rem}.mb-12{margin-bottom:3rem}.mb-6{margin-bottom:1.5rem}.mt-12{margin-top:3rem}.mt-3{margin-top:0.75rem}.mt-8{margin-top:2rem}.flex{display:flex}.grid{display:grid}.hidden{display:none}.size-full{width:100%;height:100%}.h-96{height:24rem}.max-w-2xl{max-width:42rem}.max-w-6xl{max-width:72rem}.grid-cols-1{grid-template-columns:repeat(1, minmax(0, 1fr))}.flex-col{flex-direction:column}.flex-wrap{flex-wrap:wrap}.justify-center{justify-content:center}.justify-between{justify-content:space-between}.gap-4{gap:1rem}.gap-6{gap:1.5rem}.gap-x-16{column-gap:4rem}.gap-y-4{row-gap:1rem}.space-y-10 > :not([hidden]) ~ :not([hidden]){--tw-space-y-reverse:0;margin-top:calc(2.5rem * calc(1 - var(--tw-space-y-reverse)));margin-bottom:calc(2.5rem * var(--tw-space-y-reverse))}.rounded-2xl{border-radius:1rem}.rounded-xl{border-radius:0.75rem}.border-red-200{--tw-border-opacity:1;border-color:rgb(254 202 202 / var(--tw-border-opacity, 1))}.bg-red-50{--tw-bg-opacity:1;background-color:rgb(254 242 242 / var(--tw-bg-opacity, 1))}.p-10{padding:2.5rem}.p-4{padding:1rem}.p-6{padding:1.5rem}.text-center{text-align:center}.text-2xl{font-size:1.5rem;line-height:2rem}.text-3xl{font-size:1.875rem;line-height:2.25rem}.text-base{font-size:1rem;line-height:1.5rem}.text-lg{font-size:1.125rem;line-height:1.75rem}.font-bold{font-weight:700}.text-gray-600{--tw-text-opacity:1;color:rgb(75 85 99 / var(--tw-text-opacity, 1))}.text-red-500{--tw-text-opacity:1;color:rgb(239 68 68 / var(--tw-text-opacity, 1))}.text-red-600{--tw-text-opacity:1;color:rgb(220 38 38 / var(--tw-text-opacity, 1))}.antialiased{-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.opacity-0{opacity:0}@media (min-width: 640px){.sm\:flex-row{flex-direction:row}.sm\:p-10{padding:2.5rem}}@media (min-width: 768px){.md\:grid-cols-2{grid-template-columns:repeat(2, minmax(0, 1fr))}.md\:gap-8{gap:2rem}.md\:p-12{padding:3rem}}@media (min-width: 1024px){.lg\:col-span-2{grid-column:span 2 / span 2}.lg\:grid-cols-2{grid-template-columns:repeat(2, minmax(0, 1fr))}}
</style>

<div class="antialiased">
<div class="max-w-6xl mx-auto">
<div class="main-container">
<div class="p-6 sm:p-10 md:p-12">
    <!-- Input Section -->
    <div id="input-section" class="section-transition">
        <div class="text-center mb-12">
            <!--<h1 class="text-4xl md:text-5xl font-extrabold text-dark-text">Calculate Your CRM's True Potential</h1>-->
            <h2 class="crm-title">Free CRM ROI Calculator
            </h2>
            <p class="text-gray-600 mt-3 text-lg">Unlock the Full Potential of Your CRM</p>
        </div>
        <form id="roi-form" class="space-y-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-x-16 gap-y-4">
                <!-- Input Fields -->
                <div class="flex flex-wrap justify-between align-center">
                    <label for="sales-reps" class="font-bold text-dark-text">Number of Sales Reps</label>
                        <input type="number" id="sales-reps" class="input-field" value="5" min="1" required>
                    <div class="input-group w-100">
                        <input type="range" id="sales-reps-slider" class="range-slider" min="1" max="100" value="5">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center">
                    <label for="monthly-leads" class="font-bold text-dark-text">Avg. Monthly Leads per Rep</label>
                        <input type="number" id="monthly-leads" class="input-field" value="50" min="1" required>
                    <div class="input-group w-100">
                        <input type="range" id="monthly-leads-slider" class="range-slider" min="10" max="500" value="50" step="5">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center">
                    <label for="conversion-rate" class="font-bold text-dark-text">Current Conversion Rate (%)</label>
                        <input type="number" id="conversion-rate" class="input-field" value="3" min="0" step="0.1" required>
                    <div class="input-group w-100">
                        <input type="range" id="conversion-rate-slider" class="range-slider" min="0.1" max="25" value="3" step="0.1">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center">
                    <label for="deal-size" class="font-bold text-dark-text">Average Deal Size ($)</label>
                        <input type="number" id="deal-size" class="input-field" value="5000" min="0" required>
                    <div class="input-group w-100">
                        <input type="range" id="deal-size-slider" class="range-slider" min="100" max="50000" value="5000" step="100">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center">
                    <label for="hours-saved" class="font-bold text-dark-text">Hours Saved per Week per Rep</label>
                        <input type="number" id="hours-saved" class="input-field" value="4" min="0" required>
                    <div class="input-group w-100">
                        <input type="range" id="hours-saved-slider" class="range-slider" min="0" max="20" value="4">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center">
                    <label for="hourly-rate" class="font-bold text-dark-text">Avg. Employee Hourly Rate ($)</label>
                        <input type="number" id="hourly-rate" class="input-field" value="40" min="0" required>
                    <div class="input-group w-100">
                        <input type="range" id="hourly-rate-slider" class="range-slider" min="15" max="200" value="40">
                    </div>
                </div>
                <div class="flex flex-wrap justify-between align-center lg:col-span-2">
                    <label for="crm-cost" class="font-bold text-dark-text">Total Monthly CRM Cost ($)</label>
                        <input type="number" id="crm-cost" class="input-field" value="250" min="0" required>
                    <div class="input-group w-100">
                        <input type="range" id="crm-cost-slider" class="range-slider" min="0" max="10000" value="250" step="50">
                    </div>
                </div>
            </div>

            <div class="text-center">
                <button type="submit" class="btn-primary">Calculate My ROI</button>
            </div>
        </form>
    </div>

    <!-- Results Section -->
    <div id="results-container" class="hidden section-transition opacity-0 flex-wrap justify-between">
        <div class="text-center w-100">
            <h2 class="crm-title">Your Estimated Potential</h2>
            <p class="text-gray-600 text-lg mb-10">Here's the value an optimized CRM strategy can unlock.</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 gap-6 md:gap-8 w-lg-48 w-100">
            <div class="result-card bg-secondary rounded-xl">
                <p class="result-label">Estimated Monthly ROI</p>
                <p id="result-roi" class="result-value">0%</p>
            </div>
            <div class="bg-secondary-light result-card rounded-xl">
                <p class="result-label">Annual Revenue Uplift</p>
                <p id="result-annual-revenue" class="result-value">$0</p>
            </div>
            <div class="result-card bg-red-50 border-red-200 rounded-xl">
                <p class="result-label text-red-500">Annual Missed Opportunity</p>
                <p id="result-missed-opportunity" class="result-value text-red-600">$0</p>
            </div>
            <div class="bg-light-gray result-card rounded-xl">
                <p class="result-label">Additional Deals / Month</p>
                <p id="result-additional-deals" class="result-value">0</p>
            </div>
            <div class="result-card rounded-xl bg-primary-light">
                <p class="result-label">Hours Saved / Month</p>
                <p id="result-hours-saved" class="result-value">0</p>
            </div>
            <div class="bg-secondary-light result-card rounded-xl">
                <p class="result-label">Annual Productivity Gain</p>
                <p id="result-annual-productivity" class="result-value">$0</p>
            </div>
        </div>

        <div class="w-lg-48 w-100">
            <h3 class="text-2xl font-bold text-dark-text mb-6 text-center">Annual Revenue: Before vs. After Optimization</h3>
            <div class="bg-light-gray rounded-2xl p-4 h-96">
                <canvas id="roiChart"></canvas>
            </div>
        </div>

        <div class="bg-secondary-light mt-12 p-10 rounded-2xl text-center max-w-2xl mx-auto">

                <h3 class="text-3xl font-bold text-dark-text">Ready to Realize These Gains?</h3>
            <p class="text-gray-600 mt-3 max-w-2xl mx-auto text-lg">Let our experts provide a free, no-obligation audit of your CRM to create a roadmap for maximizing your return on investment.</p>
            <div class="mt-8 flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="#schedule-call"  class="btn-primary  btn-popup-form1">Schedule Free Consultation Call</a>
                    <button id="recalculate-btn" class="btn-bordered">Calculate Again</button>
            </div>
        </div>
    </div>
</div>
</div>
</div>
 <!-- <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary': '#0010cb',
                        'primary-dark': '#000c9f',
                        'secondary': '#f0f2ff',
                        'light-gray': '#f8f9fa',
                        'dark-text': '#1f2937',
                    }
                }
            }
        }
    </script> -->
    <script>
    document.addEventListener('DOMContentLoaded', () => {
        const roiForm = document.getElementById('roi-form');
        const inputSection = document.getElementById('input-section');
        const resultsContainer = document.getElementById('results-container');
        const recalculateBtn = document.getElementById('recalculate-btn');
        let roiChartInstance = null;
        const inputs = [
            { slider: 'sales-reps-slider', input: 'sales-reps' },
            { slider: 'monthly-leads-slider', input: 'monthly-leads' },
            { slider: 'conversion-rate-slider', input: 'conversion-rate' },
            { slider: 'deal-size-slider', input: 'deal-size' },
            { slider: 'hours-saved-slider', input: 'hours-saved' },
            { slider: 'hourly-rate-slider', input: 'hourly-rate' },
            { slider: 'crm-cost-slider', input: 'crm-cost' },
        ];
        inputs.forEach(({ slider, input }) => {
            const sliderEl = document.getElementById(slider);
            const inputEl = document.getElementById(input);
            sliderEl.addEventListener('input', () => inputEl.value = sliderEl.value);
            inputEl.addEventListener('input', () => sliderEl.value = inputEl.value);
        });
        function getInputs() {
            return {
                reps: parseFloat(document.getElementById('sales-reps').value) || 0,
                leads: parseFloat(document.getElementById('monthly-leads').value) || 0,
                conversion: parseFloat(document.getElementById('conversion-rate').value) || 0,
                dealSize: parseFloat(document.getElementById('deal-size').value) || 0,
                hoursSaved: parseFloat(document.getElementById('hours-saved').value) || 0,
                crmCost: parseFloat(document.getElementById('crm-cost').value) || 0,
                hourlyRate: parseFloat(document.getElementById('hourly-rate').value) || 0,
            };
        }
        function calculateROI(inputs) {
            const conversionUpliftFactor = 1.25; // 25% improvement assumption
            const totalLeads = inputs.reps * inputs.leads;
            const currentCustomers = totalLeads * (inputs.conversion / 100);
            const currentRevenue = currentCustomers * inputs.dealSize;
            const newConversionRate = inputs.conversion * conversionUpliftFactor;
            const newCustomers = totalLeads * (newConversionRate / 100);
            const newRevenue = newCustomers * inputs.dealSize;
            const revenueUplift = newRevenue - currentRevenue;
            const monthlyHoursSaved = inputs.reps * inputs.hoursSaved * 4.33;
            const productivityValue = monthlyHoursSaved * inputs.hourlyRate;
            const totalGain = revenueUplift + productivityValue;
            const monthlyROI = inputs.crmCost > 0 ? ((totalGain - inputs.crmCost) / inputs.crmCost) * 100 : Infinity;
            const additionalDeals = newCustomers - currentCustomers;
            return {
                monthlyROI,
                annualRevenueUplift: revenueUplift * 12,
                currentAnnualRevenue: currentRevenue * 12,
                newAnnualRevenue: newRevenue * 12,
                additionalDeals,
                monthlyHoursSaved,
                annualProductivityGain: productivityValue * 12,
            };
        }
        function animateValue(element, start, end, duration, isCurrency, isPercent) {
            let startTimestamp = null;
            const step = (timestamp) => {
                if (!startTimestamp) startTimestamp = timestamp;
                const progress = Math.min((timestamp - startTimestamp) / duration, 1);
                const easedProgress = 1 - Math.pow(1 - progress, 3); // easeOutCubic
                let currentValue = easedProgress * (end - start) + start;
                if (isCurrency) {
                    element.textContent = currentValue.toLocaleString('en-US', { style: 'currency', currency: 'USD', minimumFractionDigits: 0, maximumFractionDigits: 0 });
                } else if (isPercent) {
                    element.textContent = `${currentValue.toFixed(0)}%`;
                } else {
                    element.textContent = Math.round(currentValue).toLocaleString();
                }
                if (progress < 1) {
                    window.requestAnimationFrame(step);
                }
            };
            window.requestAnimationFrame(step);
        }
        const getFontSize = () => {
  return window.innerWidth < 768 ? 8 : 14;
};
function createChart(current, after) {
    const ctx = document.getElementById('roiChart').getContext('2d');
    if (roiChartInstance) {
        roiChartInstance.destroy();
    }

    roiChartInstance = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Current Annual Revenue', 'Potential Annual Revenue'],
            datasets: [{
                label: 'Annual Revenue',
                data: [current, after],
                backgroundColor: ['#e0e7ff', '#0010cb'],
                borderColor: ['#c7d2fe', '#000c9f'],
                borderWidth: 2,
                borderRadius: 12,
                barThickness: 80
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false },
                tooltip: {
                    enabled: true,
                    backgroundColor: '#1f2937',
                    titleFont: { size: 16, weight: 'bold' },
                    bodyFont: { size: 14 },
                    padding: 12,
                    cornerRadius: 8,
                    callbacks: {
                        label: (context) => new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD', maximumFractionDigits: 0 }).format(context.parsed.y)
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false,
                    },
                    ticks: {
                        font: { size: 12, weight: '500' },
                        color: '#6b7280',
                        callback: (value) => new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD', notation: 'compact' }).format(value)
                    }
                },
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        font: { size: getFontSize(), weight: '600' },
                        color: '#374151'
                    }
                }
            },
            animation: {
                duration: 1500,
                easing: 'easeOutCubic'
            }
        }
    });
}

function showResults(results) {
    inputSection.style.transform = 'translateY(-20px)';
    inputSection.classList.add('opacity-0');
    
    setTimeout(() => {
        inputSection.classList.add('hidden');
        resultsContainer.classList.add('flex');
        resultsContainer.classList.remove('hidden');
        resultsContainer.style.transform = 'translateY(20px)';
        setTimeout(() => {
            resultsContainer.classList.remove('opacity-0');
            resultsContainer.style.transform = 'translateY(0)';
        }, 50);
    }, 400);

animateValue(document.getElementById('result-roi'), 0, results.monthlyROI, 1500, false, true);
animateValue(document.getElementById('result-annual-revenue'), 0, results.annualRevenueUplift, 1500, true);
animateValue(document.getElementById('result-missed-opportunity'), 0, results.annualRevenueUplift, 1500, true);
animateValue(document.getElementById('result-additional-deals'), 0, results.additionalDeals, 1500, false, false);
animateValue(document.getElementById('result-hours-saved'), 0, results.monthlyHoursSaved, 1500, false, false);
animateValue(document.getElementById('result-annual-productivity'), 0, results.annualProductivityGain, 1500, true);

createChart(results.currentAnnualRevenue, results.newAnnualRevenue);
}

roiForm.addEventListener('submit', (e) => {
    e.preventDefault();
    const inputs = getInputs();
    const results = calculateROI(inputs);
    showResults(results);
});

recalculateBtn.addEventListener('click', () => {
    resultsContainer.style.transform = 'translateY(-20px)';
    resultsContainer.classList.add('opacity-0');
    resultsContainer.classList.remove('flex');
     resultsContainer.classList.add('hidden');
        inputSection.classList.remove('hidden');
        inputSection.style.transform = 'translateY(20px)';
        setTimeout(() => {
            inputSection.classList.remove('opacity-0');
            inputSection.style.transform = 'translateY(0)';
        }, 50);
});
});
</script>
</div>
 <?php
    return ob_get_clean();
}
?>