<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/wordpress-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace JchOptimize\WordPress\Html\Renderer;

use JchOptimize\WordPress\Html\TabContent;

use function __;

class Section
{
    public static function miscellaneousSection(): void
    {
        echo TabContent::addTab('general-tab', true);

        $title = __('General', 'jch-optimize');

        echo TabContent::addSection($title);
    }

    public static function excludeMenuItemsSection(): void
    {
        $title = __('Exclude Menu Urls', 'jch-optimize');
        $description = __(
            'Enter any part of a url to exclude that page from optimization. You will need to add these urls to the list manually by typing the url in the textbox and click the \'Add item\' button.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function cacheStorageSection(): void
    {
        $title = __('Cache Storage', 'jch-optimize');
        $description = __(
            'Select and configure the storage adapters you want to use with JCH Optimize. The available adapters are Filesystem, APCu, Memcached, Redis, and WinCache. The default is filesystem and will be used if there is a failure to load any other adapter or if you\'re using the free version.'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function recacheSection(): void
    {
        $title = __('Recache Settings', 'jch-optimize');
        $description = __('You can configure your options for the Recache feature here.');

        echo TabContent::addSection($title, $description);
    }

    public static function combineCssJsSection(): void
    {
        echo TabContent::addTab('combine-files-tab');

        $title = __('Optimize CSS/Js', 'jch-optimize');
        $description = __(
            'Info These settings are concerned with optimizing CSS and JavaScript files, primarily minifying the contents, but also performing other optimization techniques. By default, files will not be combined together',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function combineCssJsAutoSection(): void
    {
        $title = __('Optimize Files Automatic Settings', 'jch-optimize');
        $description = __(
            'These settings are configured by the automatic settings. You don\'t need to configure them yourself.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function cssAutoSettingsSection(): void
    {
        echo TabContent::addTab('css-tab');

        $title = __('CSS Automatic Settings', 'jch-optimize');
        $description = __(
            'These settings are configured by the Automatic settings on the Control Panel tab. You don\'t need to configure them yourself.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function excludeCssSection(): void
    {
        $title = __('Exclude CSS Files', 'jch-optimize');
        $description = __(
            'Exclude individual CSS files or files from select plugins. To add an item to the drop-down list manually, type any part of the url in the textbox then click the \'Add item\' button. CSS files are always excluded while preserving execution order. If the files are combined, the combined file will split itself around excluded files to preserve the original order of files on the page. '
        );

        echo TabContent::addSection($title, $description);
    }

    public static function removeCssSection(): void
    {
        $title = __('Remove CSS Files', 'jch-optimize');
        $description = __(
            'You can remove and prevent CSS files from loading on the page if they\'re not being used at all to speed up page load and rendering. Please be sure these files are not being used anywhere on the site to prevent breaking your pages.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function customCssSection(): void
    {
        $title = __('Custom CSS', 'jch-optimize');
        $description = __(
            'This section is for adding CSS to correct Cumulative Layout Shift (CLS) issues caused by the page shifting around because the space wasn\'t allocated to accomodate the HTML elements rendering, such as some slideshows. The appropriate media queries will be generated for mobile and/or desktop, so you\'ll only need to add simple CSS declarations for e.g., #slideshow-container {min-height: 300px;}',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function optimizeCssDeliverySection(): void
    {
        $title = __('Optimize CSS Delivery', 'jch-optimize');
        $description = __(
            'The plugin will attempt to extract the critical CSS that is required to format the page above the fold and put this in a &lt;style&gt; element inside the &lt;head&gt; section of the HTML to prevent \'render-blocking\'. The generated CSS will then be loaded asynchronously. Select the number of HTML elements from the top of the page that you want the plugin to find the critical CSS for. The smaller the number, the smaller the size of the critical CSS but you might see some jumping of the page if the number is too small.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function javascriptAutomaticSettingsSection(): void
    {
        echo TabContent::addTab('javascript-tab');

        $title = __('JavaScript Automatic Settings', 'jch-optimize');
        $description = __(
            'These settings are configured by the Automatic settings on the Control Panel tab. You don\'t need to configure them yourself',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function excludePeoSection(): void
    {
        $title = __('Exclude JavaScript files', 'jch-optimize');
        $description = __(
            'Exclude individual JavaScript files or files from selected plugins. Files by default will be excluded while preserving execution order on the page by splitting the combined files around excluded files if the Combine Files setting is enabled. This ensures no dependency between files are broken and break the page. To modify this behavior, you can click to select the respective checkboxes, \'Ignore execution order\' and/or \'Don\'t move to the bottom\' for each exclusion.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function removeJsSection(): void
    {
        $title = __('Remove JavaScript Files', 'jch-optimize');
        $description = __(
            'You can remove and prevent JavaScript files from loading on the page if they\'re not being used at all. This helps to speed up page download and rendering. Please be sure these files are not being used anywhere on the site to prevent breaking your pages.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function reduceUnusedJavascriptSection(): void
    {
        $title = __('Reduce Unused JavaScript', 'jch-optimize');
        $description = __(
            'This setting will defer the loading of JavaScript on the page until after the use interacts with the page to improve page load performance adversely affected by unused JavaScript. If your site uses JavaScript to perform any of the initial render, particularly to sections of page above the fold, you may need to exclude these files using the critical JavaScript settings below.'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function pageCacheSection(): void
    {
        echo TabContent::addTab('page-cache-tab');

        $title = __('Page Cache', 'jch-optimize');
        $description = __(
            'The HTML source of the page will be cached to significantly speed up page loads. Deactivate caching while configuring the plugin and be sure to flush cache after making changes to the site.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function addImageAttributesSection(): void
    {
        echo TabContent::addTab('media-tab');

        $title = __('Add Image Attributes', 'jch-optimize');
        $description = __(
            'When enabled, the plugin will add missing \'width\' and \'height\' attributes to &lt;img/&gt; elements. PLEASE NOTE: This works best when the images are scaled to the size they are shown onscreen. If images appear the wrong size, try rescaling the images correctly or disable this option.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function spriteGeneratorSection(): void
    {
        $title = __('Sprite Generator', 'jch-optimize');
        $description = __(
            'The plugin will combine selected background images into one image called a sprite to reduce http requests. Combine CSS must be enabled for the Sprite Generator to work.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function lazyLoadSection(): void
    {
        $title = __('Lazy-Load Images');
        $description = __(
            'Enable to delay the loading of iframes, images and responsive images until they are scrolled into view. This further speeds up the loading of the page and reduces http requests.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function http2PushSection(): void
    {
        echo TabContent::addTab('preloads-tab');

        $title = __('Http/2 Preload', 'jch-optimize');
        $description = __(
            'Plugin will send appropriate headers to your server to push resource files before the browser requests them. Please note this only works if http/2 is enabled on the server',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function largestContentfulPaintSection(): void
    {
        $title = __('Largest Contentful Paint Images', 'jch-optimize');
        $description = __(
            'Use this section to preload any image identified as the LCP element with a high priority using the new \'fetchpriority\' attribute. These are only preloaded if they appear on the page and will be automatically excluded from lazy load.'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function optimizeFontsSection(): void
    {
        $title = __('Optimize Fonts', 'jch-optimize');
        $description = __(
            'Will optimize the loading of fonts by placing all @font-face content in a separate combined files and preload them. Preconnects will be added for all external domains. Google Font files will simply be preloaded since they already only contain @font-face content.'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function preconnectThirdPartySection(): void
    {
        $title = __('Preconnect Third-party Origins', 'jch-optimize');
        $description = __(
            'Reduce the impact of third-party code by establising early connections with the external origins. The origin is the part of the URL containing the scheme, hostname, and port. The plugin will add preconnects to the top of the page to reduce performance impacts of thrid-party providers. CDNs and third-party origins in CSS files can be automatically detected, but you may need to manually add preconnect for scripts in the main thread.'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function cdnSection(): void
    {
        echo TabContent::addTab('cdn-tab');

        $title = __('CDN', 'jch-optimize');
        $description = __(
            'Enter your CDN or cookieless domain here. The plugin will load all static files including background images, generated JavaScript and CSS files, and generated sprite from this domain. This requires that this domain is already set up and points to your site root.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function globalSection(): void
    {
        echo TabContent::addTab('optimize-image-tab');

        $title = __('General', 'jch-optimize');
        $description = __(
            'Use our API to optimize the images on your server. You can either let the plugin find the images on your page to optimize or manually select them in the file tree explorer. Be sure to save your \'Download ID\' in the plugin before trying to optimize images as that will authenticate you to access the API. These settings apply to both methods.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function nextGenImages(): void
    {
        $title = __('Next Generation Images', 'jch-optimize');
        $description = __('Next generation image options');

        echo TabContent::addSection($title, $description);
    }

    public static function responsiveImages(): void
    {
        $title = __('Responsive Images', 'jch-optimize');
        $description = __('Responsive images options');

        echo TabContent::addSection($title, $description);
    }

    public static function optimizationConfigurations(): void
    {
        $title = __('Optimization Configurations', 'jch-optimize');
        $description = __('The configurations settings used by the API to determine how the images are processed');

        echo TabContent::addSection($title, $description);
    }

    public static function uploadSettings(): void
    {
        $title = __('Upload Settings', 'jch-optimize');
        $description = __('Images are packaged in batches for upload to speed up the process. These settings determine how these batches are packaged and handled.', 'jch-optimize');

        echo TabContent::addSection($title, $description);
    }

    public static function autoApiSection(): void
    {
        $title = __('Optimize Images By URLs');
        $description = __(
            'The plugin will scan the pages of your website for you to find the images to optimize. You don\'t need to select them beforehand.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function manualApiSection(): void
    {
        $title = __('Optimize Images By Folders');
        $description = __(
            'Use the file tree to select the subfolders and files you want to optimize. Files will be optimized in subfolders recursively. If you want to rescale your images while optimizing, enter the new width and height in the respective columns beside each image on the right hand side.',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function reduceDomSection(): void
    {
        echo TabContent::addTab('miscellaneous-tab');

        $title = __('Reduce DOM', 'jch-optimize');
        $description = __(
            'HTML5 sectioning related elements such as header, footer, section, aside, and nav that fall below the fold will be commented out if the number of DOM elements exceed 600. These sections will be inserted back into the DOM using JavaScript after the page has been loaded. <span class="alert alert-warning" style="padding: 1px 3px;"> Warning: Use with care. Can interfere with sections that use JavaScript to render.</span>',
            'jch-optimize'
        );

        echo TabContent::addSection($title, $description);
    }

    public static function modeSwitcherSection(): void
    {
        $title = __('Mode Switcher Menu', 'jch-optimize');
        $description = __(
            'The Pro version adds a menu item via a mu-plugin that gives easy access to activate/deactivate the plugin from the menu and provides a visual indicator of what mode the plugin is in. This is useful if you are doing any development work on the site and want to temporarily deactivate the plugin so you can see the changes immediately. The cache will be automatically flushed and a different cache key generated when the plugin is toggled between Production/Development mode using the Mode Switcher.'
        );

        echo TabContent::addSection($title, $description);
    }

    private static function new(): string
    {
        return <<<HTML
<span class="badge bg-danger">New!</span>
HTML;
    }
}
