<?php
/**
 * Block Information & Attributes File.
 *
 * @since 2.2.0
 *
 * @package uagb
 */

$btn_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute(
	'btn'
);

$content_border_attributes = UAGB_Block_Helper::uag_generate_border_attribute(
	'content'
);
$additional_attributes     = apply_filters( 'spectra_modal_attributes', array() );
$additional_attributes     = is_array( $additional_attributes ) ? $additional_attributes : array();
$inherit_from_theme        = 'enabled' === ( 'deleted' !== UAGB_Admin_Helper::get_admin_settings_option( 'uag_btn_inherit_from_theme_fallback', 'deleted' ) ? 'disabled' : UAGB_Admin_Helper::get_admin_settings_option( 'uag_btn_inherit_from_theme', 'disabled' ) );

return array_merge(
	array(
		'modalTrigger'                => 'button',
		'inheritFromTheme'            => $inherit_from_theme,
		'buttonIconSpace'             => '5',
		'buttonIconSpaceTablet'       => '',
		'buttonIconSpaceMobile'       => '',
		'buttonIconSpaceType'         => 'px',
		'buttonIconPosition'          => 'after',
		'modalAlign'                  => 'left',
		'modalAlignTablet'            => '',
		'modalAlignMobile'            => '',
		'modalWidth'                  => 600,
		'modalWidthTablet'            => '',
		'modalWidthMobile'            => '',
		'modalWidthType'              => 'px',
		'modalWidthTypeTablet'        => '',
		'modalWidthTypeMobile'        => '',
		'modalHeight'                 => 350,
		'modalHeightTablet'           => '',
		'modalHeightMobile'           => '',
		'modalHeightType'             => 'px',
		'modalHeightTypeTablet'       => '',
		'modalHeightTypeMobile'       => '',
		'closeIconSize'               => 25,
		'closeIconPosition'           => 'popup-top-right',
		'overlayColor'                => 'rgba(0,0,0,0.75)',
		'closeIconColor'              => '',
		'paddingModalUnit'            => 'px',
		'mobilePaddingModalUnit'      => 'px',
		'tabletPaddingModalUnit'      => 'px',
		'paddingModalTop'             => '',
		'paddingModalBottom'          => '',
		'paddingModalLeft'            => '',
		'paddingModalRight'           => '',
		'paddingModalTopTablet'       => '',
		'paddingModalRightTablet'     => '',
		'paddingModalBottomTablet'    => '',
		'paddingModalLeftTablet'      => '',
		'paddingModalTopMobile'       => '',
		'paddingModalRightMobile'     => '',
		'paddingModalBottomMobile'    => '',
		'paddingModalLeftMobile'      => '',

		'iconSize'                    => 30,
		'iconColor'                   => '',
		'textColor'                   => '',

		'textFontFamily'              => '',
		'textLoadGoogleFonts'         => false,
		'textFontWeight'              => '',
		'textFontStyle'               => '',
		'textFontSize'                => '',
		'textFontSizeType'            => 'px',
		'textFontSizeTablet'          => '',
		'textFontSizeMobile'          => '',
		'textSpaceType'               => 'px',
		'textLineHeight'              => '',
		'textLineHeightType'          => 'em',
		'textLineHeightTablet'        => '',
		'textLineHeightMobile'        => '',
		'textLetterSpacing'           => '',
		'textLetterSpacingTablet'     => '',
		'textLetterSpacingMobile'     => '',
		'textLetterSpacingType'       => 'px',
		'textTransform'               => '',
		'textDecoration'              => '',

		'imageSize'                   => 'thumbnail',
		'imageWidthType'              => true,
		'imageWidth'                  => '',
		'imageWidthMobile'            => '',
		'imageWidthTablet'            => '',
		'imageWidthUnit'              => 'px',
		'imageWidthUnitTablet'        => 'px',
		'imageWidthUnitMobile'        => 'px',
		'iconimgBorderRadius'         => '0',
		'iconimgBorderRadiusUnit'     => 'px',

		'paddingBtnUnit'              => 'px',
		'mobilePaddingBtnUnit'        => 'px',
		'tabletPaddingBtnUnit'        => 'px',
		'paddingBtnTop'               => 14,
		'paddingBtnBottom'            => 14,
		'paddingBtnLeft'              => 32,
		'paddingBtnRight'             => 32,
		'paddingBtnTopTablet'         => '',
		'paddingBtnRightTablet'       => '',
		'paddingBtnBottomTablet'      => '',
		'paddingBtnLeftTablet'        => '',
		'paddingBtnTopMobile'         => '',
		'paddingBtnRightMobile'       => '',
		'paddingBtnBottomMobile'      => '',
		'paddingBtnLeftMobile'        => '',

		'btnFontFamily'               => '',
		'btnLoadGoogleFonts'          => false,
		'btnFontWeight'               => '',
		'btnFontStyle'                => '',
		'btnFontSize'                 => '',
		'btnFontSizeType'             => 'px',
		'btnFontSizeTablet'           => '',
		'btnFontSizeMobile'           => '',
		'btnSpaceType'                => 'px',
		'btnLineHeight'               => '',
		'btnLineHeightType'           => 'em',
		'btnLineHeightTablet'         => '',
		'btnLineHeightMobile'         => '',
		'btnLetterSpacing'            => '',
		'btnLetterSpacingTablet'      => '',
		'btnLetterSpacingMobile'      => '',
		'btnLetterSpacingType'        => 'px',
		'btnTransform'                => '',
		'btnDecoration'               => '',
		'btnLinkColor'                => '',
		'btnBgColor'                  => '',
		'btnLinkHoverColor'           => '',
		'btnBgHoverColor'             => '',
		'modalBoxHeight'              => 'auto',
		'maxHeight'                   => '90',
		'maxHeightTablet'             => '',
		'maxHeightMobile'             => '',
		'maxHeightType'               => 'vh',
		'backgroundType'              => 'none',
		'backgroundImageDesktop'      => '',
		'backgroundImageTablet'       => '',
		'backgroundImageMobile'       => '',
		'backgroundPositionDesktop'   => array(
			'x' => 0.5,
			'y' => 0.5,
		),
		'backgroundPositionTablet'    => '',
		'backgroundPositionMobile'    => '',
		'backgroundSizeDesktop'       => 'cover',
		'backgroundSizeTablet'        => '',
		'backgroundSizeMobile'        => '',
		'backgroundRepeatDesktop'     => 'no-repeat',
		'backgroundRepeatTablet'      => '',
		'backgroundRepeatMobile'      => '',
		'backgroundAttachmentDesktop' => 'scroll',
		'backgroundAttachmentTablet'  => '',
		'backgroundAttachmentMobile'  => '',
		'backgroundColor'             => '',
		'backgroundOpacity'           => '',
		'backgroundImageColor'        => '#FFFFFF75',
		'gradientValue'               => 'linear-gradient(90deg, rgba(6, 147, 227, 0.5) 0%, rgba(155, 81, 224, 0.5) 100%)',
		'gradientColor1'              => '#06558a',
		'gradientColor2'              => '#0063A1',
		'gradientType'                => 'linear',
		'gradientLocation1'           => 0,
		'gradientLocation2'           => 100,
		'gradientAngle'               => 0,
		'selectGradient'              => 'basic',
		'backgroundCustomSizeDesktop' => 100,
		'backgroundCustomSizeTablet'  => '',
		'backgroundCustomSizeMobile'  => '',
		'backgroundCustomSizeType'    => '%',
		'overlayType'                 => 'none',
		'customPosition'              => 'default',
		'xPositionDesktop'            => '',
		'xPositionTablet'             => '',
		'xPositionMobile'             => '',
		'xPositionType'               => 'px',
		'xPositionTypeTablet'         => 'px',
		'xPositionTypeMobile'         => 'px',
		'yPositionDesktop'            => '',
		'yPositionTablet'             => '',
		'yPositionMobile'             => '',
		'yPositionType'               => 'px',
		'yPositionTypeTablet'         => 'px',
		'yPositionTypeMobile'         => 'px',
		'setCookiesOn'                => 'close-action',
		'modalTriggerBgType'          => 'color',
		'modalTriggerBgHoverType'     => 'color',
	),
	$btn_border_attributes,
	array(
		'btnBorderTopLeftRadius'     => 3,
		'btnBorderTopRightRadius'    => 3,
		'btnBorderBottomLeftRadius'  => 3,
		'btnBorderBottomRightRadius' => 3,
	),
	$content_border_attributes,
	array(
		'contentBorderTopLeftRadius'     => 3,
		'contentBorderTopRightRadius'    => 3,
		'contentBorderBottomLeftRadius'  => 3,
		'contentBorderBottomRightRadius' => 3,
	),
	$additional_attributes
);
