<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonJdschedule extends SppagebuilderAddons {

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$style = (isset($this->addon->settings->style) && $this->addon->settings->style) ? $this->addon->settings->style : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
		$heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';

		//Output
		$output  = '<div  id="jd_schedule" class="sppb-addon sppb-addon-tab ' . $class . '">';
		$output  = '<div class="jd_schedule_inner">';
		$output .= ($title) ? '<'.$heading_selector.' class="sppb-addon-title">' . $title . '</'.$heading_selector.'>' : '';
		$output .= '<div class="sppb-addon-content sppb-tab">';

		//Tab Title
		$output .='<ul class="jd_schedule_tabs sppb-nav sppb-nav-' . $style . '">';
		foreach ($this->addon->settings->sp_tab_item as $key => $tab) {
			$title = (isset($tab->icon) && $tab->icon) ? '<i class="fa ' . $tab->icon . '"></i> ' . $tab->title : $tab->title;
			$output .='<li class="'. ( ($key==0) ? "active" : "").'"><a data-toggle="sppb-tab" href="#sppb-tab-'. ($this->addon->id + $key) .'">'. $title .'</a></li>';
		}
		$output .='</ul>';

		//Tab Contnet
		$output .='<div class="sppb-tab-content sppb-nav-' . $style . '-content">';
		foreach ($this->addon->settings->sp_tab_item as $key => $tab) {
			
			$output .='<div id="sppb-tab-'. ($this->addon->id + $key) .'" class="sppb-tab-pane sppb-fade'. ( ($key==0) ? " active in" : "").'">';
			$output .= '<div class="jd_schedule_lists">';
			for ($q = 1; $q <= 10; $q++){
				if(!empty($tab->{'title'.$q}) ){
						$output .= '<div class="jd_schedule_list">';
											if(!empty($tab->{'photo'.$q})){
												$output .= '<div class="jd_schedule_thumb"><img src="'.$tab->{'photo'.$q}.'" alt=""></div>';
											}	
											$output .='<div class="jd_schedule_details">';
											$output .='<div class="top_info">';
											if(!empty($tab->{'time'.$q})){
												$output .='<div class="time"><i class="fa fa-clock-o" aria-hidden="true"></i>'.$tab->{'time'.$q}.'</div>';
											}
											if(!empty($tab->{'location'.$q})){
												$output .='<div class="location"><i class="fa fa-map-marker" aria-hidden="true"></i>'.$tab->{'location'.$q}.'</div>';
											}
											$output .='<div class="clr"></div>'; 
											$output .='</div>';
											if(!empty($tab->{'title'.$q})){
												$output .='<h2 class="jd_schedule_title">'.$tab->{'title'.$q}.'</h2>';
											}
											if(!empty($tab->{'desc'.$q})){
												$output .=' <p class="description">'.$tab->{'desc'.$q}.'</p>';
											}
											if(!empty($tab->{'speaker'.$q})){
												$output .='<span class="hostname"><i class="fa fa-microphone" aria-hidden="true"></i>'.$tab->{'speaker'.$q}.'</span>';
											}
										$output .='</div>
						</div>';
				}
			}
			$output .='</div>';
			$output .='</div>';
		}
		$output .='</div>';
		$output .= '</div>';
		$output .= '</div>';

		return $output;

	}

	public function css() {
		$addon_id = '#sppb-addon-' . $this->addon->id;
		$tab_style = (isset($this->addon->settings->style) && $this->addon->settings->style) ? $this->addon->settings->style : '';
		$style = (isset($this->addon->settings->active_tab_color) && $this->addon->settings->active_tab_color) ? 'color: ' . $this->addon->settings->active_tab_color . ';': '';

		$css = '';
		if($tab_style == 'pills') {
			$style .= (isset($this->addon->settings->active_tab_bg) && $this->addon->settings->active_tab_bg) ? 'background-color: ' . $this->addon->settings->active_tab_bg . ';': '';
			if($style) {
				$css .= $addon_id . ' .sppb-nav-pills > li.active > a,' . $addon_id . ' .sppb-nav-pills > li.active > a:hover,' . $addon_id . ' .sppb-nav-pills > li.active > a:focus {';
				$css .= $style;
				$css .= '}';
			}
		} else if ($tab_style == 'lines') {
			$style .= (isset($this->addon->settings->active_tab_bg) && $this->addon->settings->active_tab_bg) ? 'border-bottom-color: ' . $this->addon->settings->active_tab_bg . ';': '';
			if($style) {
				$css .= $addon_id . ' .sppb-nav-lines > li.active > a,' . $addon_id . ' .sppb-nav-lines > li.active > a:hover,' . $addon_id . ' .sppb-nav-lines > li.active > a:focus {';
				$css .= $style;
				$css .= '}';
			}
		}

		return $css;
	}

}
