<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted access');

class SppagebuilderAddonJd_tweets extends SppagebuilderAddons {

	public function render() {

		$class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
		$title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
		$heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';

        
        $display_bullets = empty($this->addon->settings->display_bullets)?'false':'true';
        $display_arrows = empty($this->addon->settings->display_arrows)?'false':'true';
        
		//Options
		$autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? ' data-sppb-ride="sppb-carousel"' : '';
		$username = (isset($this->addon->settings->username) && $this->addon->settings->username) ? $this->addon->settings->username : 'joomdev';
		$consumerkey = (isset($this->addon->settings->consumerkey) && $this->addon->settings->consumerkey) ? $this->addon->settings->consumerkey : '';
		$consumersecret = (isset($this->addon->settings->consumersecret) && $this->addon->settings->consumersecret) ? $this->addon->settings->consumersecret : '';
		$accesstoken = (isset($this->addon->settings->accesstoken) && $this->addon->settings->accesstoken) ? $this->addon->settings->accesstoken : '';
		$accesstokensecret = (isset($this->addon->settings->accesstokensecret) && $this->addon->settings->accesstokensecret) ? $this->addon->settings->accesstokensecret : '';
		$include_rts = (isset($this->addon->settings->include_rts) && $this->addon->settings->include_rts) ? $this->addon->settings->include_rts : '';
		$ignore_replies = (isset($this->addon->settings->ignore_replies) && $this->addon->settings->ignore_replies) ? $this->addon->settings->ignore_replies : '';
		$show_image = (isset($this->addon->settings->show_image)) ? $this->addon->settings->show_image : 1;
		$show_username = (isset($this->addon->settings->show_username) && $this->addon->settings->show_username) ? $this->addon->settings->show_username : '';
		$show_avatar = (isset($this->addon->settings->show_avatar) && $this->addon->settings->show_avatar) ? $this->addon->settings->show_avatar : '';
		$count = (isset($this->addon->settings->count) && $this->addon->settings->count) ? $this->addon->settings->count : '';

		//Warning
		if($consumerkey=='') 		return '<div class="sppb-alert sppb-alert-danger"><strong>Error</strong><br>Insert consumer key for twitter feed slider addon</div>';
		if($consumersecret=='') 	return '<div class="sppb-alert sppb-alert-danger"><strong>Error</strong><br>Insert consumer secrete key for twitter feed slider addon</div>';
		if($accesstoken=='') 		return '<div class="sppb-alert sppb-alert-danger"><strong>Error</strong><br>Insert access token for twitter feed slider addon</div>';
		if($accesstokensecret=='') 	return '<div class="sppb-alert sppb-alert-danger"><strong>Error</strong><br>Insert access token secrete key for twitter feed slider addon</div>';

		//include tweet helper
		$tweet_helper = JPATH_ROOT . '/components/com_sppagebuilder/helpers/tweet/helper.php';
		if (!file_exists($tweet_helper)) {
			return '<p class="alert alert-danger">' . JText::_('COM_SPPAGEBUILDER_ADDON_TWEET_HELPER_FILE_MISSING') . '</p>';
		} else {
			require_once $tweet_helper;
		}

		//Get Tweets
		$tweets = sppbAddonHelperTweet::getTweets( $username, $consumerkey, $consumersecret, $accesstoken, $accesstokensecret, $count, $ignore_replies, $include_rts );
		if (isset($tweets->errors) && $tweets->errors) {
			return '<p class="sppb-alert sppb-alert-warning">' . $tweets->errors[0]->message . '</p>';
		}
		//Output
		if(count($tweets)>0) {
			
			$document = JFactory::getDocument();
			$template = JFactory::getApplication()->getTemplate();
			$document->addStylesheet(JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_tweets/assets/css/owl.carousel.min.css');
			$document->addStylesheet(JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_tweets/assets/css/owl.theme.default.min.css');
			$document->addScript('https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js');
			
			$document->addScriptDeclaration('jQuery(document).ready(function($){  $(".jd-tweets-content-'.$this->addon->id.'").owlCarousel({
				loop:false,
				margin:15,
				dots:'.$display_bullets.',
				responsive:{
					0:{
						items:1
					}
				}
			}); });');
			//print_r($tweets);
			//exit();
			$output  = '<div class="jd-tweets">';
			$output .= ($title) ? '<'.$heading_selector.' class="jd-tweet-title">' . $title . '</'.$heading_selector.'>' : '';
			$output  .= '<div class="jd-tweets-inner">';
			$output  .= '<div class="jd-tweets-avatar"><a target="_blank" href="http://twitter.com/'. $tweets[0]->user->screen_name .'">';
			$output  	.= ($show_avatar) ? '<img src="'. $tweets[0]->user->profile_image_url .'" alt="'. $tweets[0]->user->name .'">' : '<img src="'.JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_tweets/assets/images/twetter-icon.png" />';
			$output  .= '</a></div>';
			$output  .= '<div class="jd-tweets-content jd-tweets-content-'.$this->addon->id.' owl-carousel owl-theme">';
			foreach ($tweets as $key => $tweet) {
				$output  .= '<div class="item row">';
				$output  .= '<div class="col-xs-12 jd-tweet-item">';
				$tweet->text = preg_replace("/((http)+(s)?:\/\/[^<>\s]+)/i", "<a href=\"\\0\" target=\"_blank\">\\0</a>", $tweet->text );
				$tweet->text = preg_replace("/[@]+([A-Za-z0-9-_]+)/", "<a href=\"http://twitter.com/\\1\" target=\"_blank\">\\0</a>", $tweet->text);
				$tweet->text = preg_replace("/[#]+([A-Za-z0-9-_]+)/", "<a href=\"http://twitter.com/search?q=%23\\1\" target=\"_blank\">\\0</a>", $tweet->text);
				preg_replace('/<\/?a[^>]*>/','', $tweet->text);
				$output  .= '<span class="jd-tweet-tweet">'.$tweet->text.'</span>';
				$output  .= '<span class="jd-tweet-time">' . sppbAddonHelperTweet::timeago($tweet->created_at) . '</span>';
				$output  .= ($show_username) ? '<span class="sppb-tweet-username"><a target="_blank" href="http://twitter.com/'. $tweets[0]->user->screen_name .'">' . $tweets[0]->user->name . '</a></span>' : '';
				$output  .= '</div>';
				$output  .= '</div>';
			}
			
			$output  .= '</div>';
			$output  .= '</div>';
			$output  .= '</div>';
			return $output;
		}
		return;
	}
}