<?php
/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

class SppagebuilderAddonJd_gallery_carousel extends SppagebuilderAddons {

	public function render() {
		//Output
		$output  = '';
        $galleries = array();
        
        $display_bullets = empty($this->addon->settings->display_bullets)?'false':'true';
        $display_arrows = empty($this->addon->settings->display_arrows)?'false':'true';
        
		foreach ($this->addon->settings->jd_gallery_item as $key => $item) {
            $gallery = array();
            $gallery["title"] = $item->gallery_title;
            $dirname = JPATH_BASE.'/'.$item->gallery_path.'/';
            $images = array();
            if(file_exists($dirname)){
                foreach(glob($dirname."*.png") as $image){
                    $images[] = JURI::root().$item->gallery_path.'/'.basename($image);
                }
                foreach(glob($dirname."*.jpg") as $image){
                    $images[] = JURI::root().$item->gallery_path.'/'.basename($image);
                }
                foreach(glob($dirname."*.jpeg") as $image){
                    $images[] = JURI::root().$item->gallery_path.'/'.basename($image);
                }
                foreach(glob($dirname."*.gif") as $image){
                    $images[] = JURI::root().$item->gallery_path.'/'.basename($image);
                }
            }
            $order = empty($item->ordering) ? 'asc' : $item->ordering;
            if($order=='asc'){
                sort($images);
            }else{
                rsort($images);
            }
            $gallery["images"] = $images;
            $gallery["cols"] = empty($item->cols)?2:$item->cols;
            $gallery["rows"] = empty($item->rows)?1:$item->rows;
			$galleries[] = $gallery;
		}
        //print_r($galleries);exit;
        if(!empty($galleries)){
            $document = JFactory::getDocument();
            $template = JFactory::getApplication()->getTemplate();
            $document->addStylesheet(JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_gallery_carousel/assets/css/owl.carousel.min.css');
            $document->addStylesheet(JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_gallery_carousel/assets/css/owl.theme.default.min.css');
            $document->addStylesheet(JURI::root().'templates/'.$template.'/sppagebuilder/addons/jd_gallery_carousel/assets/css/jquery.fancybox.min.css');
            $document->addScript('https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.2.1/owl.carousel.min.js');
            $document->addScript('https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.1.20/jquery.fancybox.min.js');
            $document->addScript('https://cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.1.13/jquery.mousewheel.min.js');
            $document->addScriptDeclaration('jQuery(document).ready(function($){  $(".jd_gallery_carousel-'.$this->addon->id.'").owlCarousel({
                loop:false,
                margin:15,
                nav:'.$display_arrows.',
                dots:'.$display_bullets.',
                responsive:{
                    0:{
                        items:1
                    }
                }
            });  $("[data-fancybox]").fancybox({ }); });');
            $output .= '<div class="jd_galleries">';
            $output .= '<ul class="nav nav-tabs" role="tablist">';
            $active = 1;
            foreach($galleries as $key => $gallery){
                $output .= '<li class="'.($active?'active':'').'" role="presentation"><a href="#jd_gallery_'.$key.'" aria-controls="jd_gallery_'.$key.'" role="tab" data-toggle="tab">'.$gallery['title'].'</a></li>';
                $active = 0;
            }
            $output .= '</ul>';
            $output .= '<div class="tab-content">';
            $active = 1;
            foreach($galleries as $key => $gallery){
                $output .= '<div role="tabpanel" id="jd_gallery_'.$key.'" class="tab-pane '.($active?'active':'').'">';
                
                $output .= '<div class="jd_gallery_desktop">';
                $output .= '<div class="jd_gallery jd_gallery_carousel jd_gallery_carousel-'.$this->addon->id.' owl-carousel owl-theme">';
                    $active = 0;
                    $images = array_chunk($gallery['images'],$gallery['cols']);
                    $images = array_chunk($images,$gallery['rows']);
                    foreach($images as $rows){
                        $output .= '<div class="item">';
                        foreach($rows as $row){
                            $output .= '<div class="row">';
                            foreach($row as $image){
                                $output .= '<a class="jd_gallery_thumb" data-fancybox="jd_gallery_'.$key.'" href="'.$image.'"><div class="col-sm-'.(12/$gallery['cols']).'" style="background:url(\''.$image.'\') center no-repeat; background-size:cover; height:350px;">';
                                $output .= '</div></a>';
                            }
                            $output .= '</div>';
                        }
                        $output .= '</div>';
                    }
                $output .= '</div>';
                $output .= '</div>';
                $output .= '<div class="jd_gallery_mobile">';
                $output .= '<div class="jd_gallery jd_gallery_carousel jd_gallery_carousel-'.$this->addon->id.' owl-carousel owl-theme">';
                    $active = 0;
                    $images = $gallery['images'];
                    foreach($images as $image){
                        $output .= '<div class="item"><div class="row"><a class="jd_gallery_thumb" data-fancybox="jd_gallery_'.$key.'" href="'.$image.'"><div class="col-xs-12" style="background:url(\''.$image.'\') center no-repeat; background-size:cover; height:350px;">';
                        $output .= '</div></a></div></div>';
                    }
                $output .= '</div>';
                $output .= '</div>';
                
                $output .= '</div>';
            }
            $output .= '</div>';
            $output .= '</div>';
        }
        
		return $output;

	}
    
}
