<?php
  $classes = classNames( "qx-element qx-element-{$type} {$field['class']}", $visibilityClasses, [
    "wow {$field['animation']}" => $field['animation'],
    "qx-hvr-{$field['hover_animation']}" => ($field['animation_apply'] === 'body')
  ]);

  // Animation delay
  $animation_delay = '';
  if( $field['animation'] AND array_key_exists('animation_delay', $field) ){
    $animation_delay = 'data-wow-delay="'. $field['animation_delay'] .'s"';
  }
  $hover_class = " qx-hvr-{$field['hover_animation']}";

  // Media
  $media = '';
  $media_hover_class = ($field['animation_apply'] === 'media') ? $hover_class : '';
  $media = '<img class="qx-image ' . $media_hover_class .'" src="'.$field['image']. '" alt="'.$field['image_alt_text'].'" />';
  // Title
  $title_hover_class = ($field['animation_apply'] === 'title') ? $hover_class : '';
  $title = "<{$field['title_tag']} class=\"qx-blurb-title $title_hover_class\"> {$field['title']} </{$field['title_tag']}>";
  // Sub Title
  $title_hover_class = ($field['animation_apply'] === 'sub_title') ? $hover_class : '';
  $sub_title = "<div class=\"qx-blurb-sub_title $title_hover_class\">{$field['sub_title']}</div>";

?>

<div id="<?php echo $id; ?>" class="<?php echo $classes; ?>" <?php echo $animation_delay; ?>>

<?php echo $media; ?>
<div class="inner">
	<div class="left">
		<a class="readmore" href="<?php echo $field['link']['url']; ?>" rel="noopener noreferrer"><i class="fa fa-long-arrow-right" aria-hidden="true"></i></a>
	</div>
	<div class="right">
		<a href="<?php echo $field['link']['url']; ?>" rel="noopener noreferrer">
		<?php echo $title; ?>
		<?php echo $sub_title; ?>
		</a>
	</div>
	<div class="clearfix"></div>
</div>

</div>
<!-- qx-element-blurb -->
