<?php
if( ! class_exists('JDarticles') )
{
  include_once ( __DIR__ . '/helper.php' );
}

$articles = array_reduce(JDarticles::getListA(), function ( $carry, $article ) {
  $carry[$article->id] = $article->name;
  return $carry;
}, [ ] );

return [
  'slug' => 'jd-k2-articles',
  'name' => 'JD K2 Articles',
  'groups' => 'JoomDev',
  'form' => [
    'general' => [
      [ 
        'name' => 'article_id', 
        'type' => 'select',  
        'label' => 'Select Category',
        'options' => $articles 
      ],
      [
        'name' => 'count',
        'type' => 'text',
        'label'=> 'Count',
        'value'=> '2'
      ],
	  [
        'name' => 'show_intro_text',
        'type' => 'switch',
        'label'=> 'Show Intro Text',
		'value'=> true
      ],
	    [
        'name' => 'article_ordering',
        'type' => 'select',
        'label'=> 'Article Ordering',
        'value' => 'latest',
        'options' =>[
          'latest' => 'Latest',
          'popular' => 'Popular',
          'aorder' => 'Article Order',
          'title' => 'Title'
        ]
      ],
	   [
        'name' => 'show_date',
        'type' => 'switch',
        'label'=> 'Show Date',
		'value'=> true
      ],
	   [
        'name' => 'show_category_name',
        'type' => 'switch',
        'label'=> 'Show Category Name',
		'value'=> true
      ],
	   [
        'name' => 'show_author',
        'type' => 'switch',
        'label'=> 'Show Author',
		'value'=> true
      ],
	    [
        'name' => 'show_read_more',
        'type' => 'switch',
        'label'=> 'Show Read More'
      ],
	    [
        'name' => 'link_titles',
        'type' => 'switch',
        'label'=> 'Link Titles',
        'value'=> false
      ],
    ],
    'styles' => [
      [
        'name' => 'title_styles',
        'type' => 'divider'
      ],
      [
        'name' => 'title_font',
        'type' => 'typography',
        'label' => 'Font'
      ],
      [
        'name' => 'title_color',
        'type' => 'color',
        'label' => 'Color'
      ],
      [
        'name' => 'element_styles',
        'type' => 'divider'
      ],
      [
        'name' => 'alignment',
        'type' => 'select',
        'value' => 'left',
        'label' => 'Text Alignment',
        'image' => true,
        'responsive' => true,
        'options' =>[
          'left' => 'Left',
          'center' => 'Center',
          'right' => 'Right',
          'justify' => 'Justify'
        ]
      ],
      [
        'name' => 'body_font',
        'type' => 'typography',
        'label' => 'Font'
      ],
      [
        'name' => 'body_font_color',
        'type' => 'color',
        'label' => 'Text Color'
      ],
      [
        'name' => 'bg_color',
        'type' => 'color',
        'label' => 'Background Color'
      ],
      [
        'name' => 'margin',
        'type' => 'margin'
      ],
      [
        'name' => 'padding',
        'type' => 'padding'
      ],
      [
        'name' => 'box_shadow_styles',
        'type' => 'divider'
      ],
      [
        'name' => 'box_shadow',
        'type' => 'switch',
        'label' => 'Enable Box Shadow'
      ],
      [
        'name' => 'box_shadow_color',
        'type' => 'color',
        'label' => 'Color',
        'depends' =>[ 'box_shadow' => true ]
      ],
      [
        'name' => 'box_shadow_blur',
        'type' => 'slider',
        'label' => 'Blur',
        'max' => '200',
        'suffix' => 'px',
        'depends' => [ 'box_shadow' => true ]
      ],
      [
        'name' => 'box_shadow_spread',
        'type' => 'slider',
        'label' => 'Spread',
        'max' => '200',
        'suffix' => 'px',
        'depends' => [ 'box_shadow' => true ]
      ],
      [
        'name' => 'box_shadow_horizontal',
        'type' => 'slider',
        'label' => 'Horizontal',
        'min' => '-250',
        'max' => '250',
        'suffix' => 'px',
        'depends' => [ 'box_shadow' => true ]
      ],
      [
        'name' => 'box_shadow_vertical',
        'type' => 'slider',
        'label' => 'Vertical',
        'min' => '-250',
        'max' => '250',
        'suffix' => 'px',
        'depends' => ['box_shadow' => true ]
      ],
      [
        'name' => 'box_shadow_inset',
        'type' => 'switch',
        'label' => 'Inset',
        'help' => 'If specified, the shadows are drawn inside the frame.',
        'depends' => [ 'box_shadow' => true ]
      ]
    ]
  ],

];
