<?php
  $classes = classNames("qx-element qx-element-{$type} {$field['class']}", $visibilityClasses,[
    "wow {$field['animation']}" => $field['animation'],
    "qx-hvr-{$field['hover_animation']}" => $field['hover_animation']
  ]);
  $animation_delay = '';
  if( $field['animation'] AND array_key_exists('animation_delay', $field) ){
    $animation_delay = 'data-wow-delay="'. $field['animation_delay'] .'s"';
  }
  $app    = JFactory::getApplication();
  $doc = JFactory::getDocument();
  $templatedPath   = JURI::base(true).'/templates/'.$app->getTemplate().'/';

  Assets::Css('qx-slick-theme', QUIX_URL."/assets/css/slick-theme.css");
  Assets::Css('qx-slick', QUIX_URL."/assets/css/slick.css");
  // JS script
  Assets::Js('qx-slick', QUIX_URL."/assets/js/slick.min.js");
  $rootPath = JURI::root();
  $rootPath = str_replace('https://', '', $rootPath);
  $rootPath = str_replace('http://', '', $rootPath);
  $rootPath = str_replace($_SERVER['SERVER_NAME'], '', $rootPath);
  
  $doc->addScript($rootPath."media/com_hikashop/js/hikashop.js");
  $doc->addScript($rootPath."plugins/hikashop/cartnotify/media/notify.min.js");
  $classes = classNames( "qx-element qx-element-{$type} {$field['class']}", $visibilityClasses);
  
 
  $productTypeList = array();
  $productTypeList['new_arrival'] = @($field['new_arrival'])?('New Arrival'):'';
  $productTypeList['hot_products'] = @($field['hot_products'])?('Hot Products'):'';
  $productTypeList['best_beller'] = @($field['best_beller'])?('Best Seller'):'';

  if( ! class_exists('JdHikashopCategory') )
	{
	  include_once ( __DIR__ . '/helper.php' );
	}
    if( preg_match('/responsive_preview/i', $field['slides_count']) ){
        $slide = json_decode($field['slides_count']);
        // Slide To Show
        $slide_count_desktop = $slide->desktop;
        $slide_count_tablet = $slide->tablet;
        $slide_count_phone = $slide->phone;
      }else{
        $slide_count_desktop = $slide_count_tablet = $slide_count_phone = $field['slides_count'];
      }
      if(!$slide_count_tablet){
        $slide_count_tablet = '2';
      }
      if(!$slide_count_phone){
        $slide_count_phone = '1';
      }
      if(!$slide_count_desktop){
        $slide_count_desktop = '4';
      }
  $productDetailsLists = JdHikashopCategory::getCategoryProductList($field['category'],$field['display_products']);
?>

 <div class="jd-hikashop-category-element <?php echo $classes;?>" <?php echo $animation_delay; ?> id="<?php echo $id;?>">
        <div class="container">
            <div class="jd-category-slider jd-hikashop-category-wrapper">
                <div class="row jd-slider-row">
                    <div class="col-md-5 jd-slider-col">
                        <div class="jd-product-heading-wrapper">
                        	<?php
                        	$title = ''; $subtitile = '';
                        	if(@$field['title']){
	                        	$title =  '<'.$field['title_tag'].' class="jd-slider-heading">'.$field['title'].'</'.$field['title_tag'].'>';
	                        }
	                        if(@$field['subtitle']){
	                            $subtitile =  '<p class="jd-slider-subHeading">'.$field['subtitle'].'</p>';
	                        }
	                        $titleText = $title . $subtitile;
	                        if(@$field['subtitle_pos'] == 'Before'){
	                        	$titleText = $subtitile . $title;
	                        }
	                        echo $titleText;
                            ?>
                        </div>
                    </div>
                    <div class="col-md-7 jd-slider-col jd-slider-tabs">
                        <div class="jd-slider-category-item-list jd-hikashop-category-item-list">
                            <ul class="jd-unstyled-list">
                            	<?php
                            		$customProTypeClass = 'active';
                            		foreach ($productTypeList as $productTypeListKey => $productTypeListValue) {
                            			echo '<li class="'.$customProTypeClass.'"><a href="#" id="'.$productTypeListKey.'" data-id="'.$productTypeListKey.'">'.$productTypeListValue.'</a></li>';
                            			$customProTypeClass = '';
                            		}
                            	?>
                               
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="jd-hikashop-category-container">
                    <?php 
                    $sliderDisplay = 'display:block;';
                    foreach ($productDetailsLists as $key => $productDetails) { ?>
                    <div class="jd-hikashop-category-item-wrapper" id="<?php echo $id.$key; ?>" style="<?php echo $sliderDisplay;?>" >
                    	<?php  
                        $sliderDisplay = 'display:none;';
                    	foreach ($productDetails as $productDetail) { 
                    		?>
                    		<div class="jd-hikashop-category-item">
	                            <div class="jd-hikashop-category-item-image text-center">
	                                <a href="<?php echo $productDetail['proLink'];?>"><img src="<?php echo $productDetail['image'];?>" alt=""></a>
	                            </div>
	                            <div class="jd-hikashop-category-item-content text-center">
	                                <div class="jd-slider-cart-wrapper">
	                                    <ul class="jd-unstyled-list">
	                                        <li class="jd-icon-cart"><a href="<?php echo $productDetail['cartLink'];?>" onclick="if(window.hikashop.addToCart) { return window.hikashop.addToCart(this); }" data-addtocart="<?php echo $productDetail['product_id'];?>"  data-addto-class="add_in_progress"></a></li>
	                                        <li class="jd-icon-heart"><a href="<?php echo $productDetail['wishlistLink'];?>" onclick="if(window.hikashop.addToWishlist) { return window.hikashop.addToWishlist(this); }" data-addtowishlist="<?php echo $productDetail['product_id'];?> data-addto-class="add_in_progress"></a></li>
	                                    </ul>
	                                </div>
	                                <div class="jd-slider-rating">
	                                    <ul class="jd-unstyled-list">
	                                    	<?php 
	                                    		for ($i = 1 ; $i <= $productDetail['product_average_score']; $i++) {
	                                    			echo '<li><a href="#"><span class="icon-star"></span></a></li>';
	                                    		}
	                                    	?>                        
	                                        
	                                    </ul>
	                                </div>
	                                <h5 class="jd-hikashop-category-heading"><a href="<?php echo $productDetail['proLink'];?>"><?php echo $productDetail['product_name'];?></a></h5>
	                                <p class="jd-hikashop-category-price"><a href="#">$<?php echo sprintf("%.2f",$productDetail['price']) ;?></a></p>
	                            </div>
	                        </div>
                    		
                    	<?php } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

<script type="text/javascript">
    id = '<?php echo $id;?>';
    runningslider = '#<?php echo $id.'new_arrival'; ?>';
	jQuery(document).ready(function(){
        jQuery(runningslider).slick({
            dots: <?php echo ($field['dis_bullets']) ? 'true' : 'false';?>,
            arrows: <?php echo ($field['dis_arrows']) ? 'true' : 'false';?>,
            touchMove: true,
            autoplay: <?php echo ($field['autoplay']) ? 'true' : 'false';?>,
            autoplaySpeed: <?php echo ($field['autoplay_speed']) ? $field['autoplay_speed'] : '1200';?>,
            slidesToShow: <?php echo $slide_count_desktop;?>,
            pauseOnHover: true,
            responsive: [
                 {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: <?php echo $slide_count_desktop;?>,
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: <?php echo $slide_count_tablet;?>,
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: <?php echo $slide_count_phone;?>,
                    }
                }
      		]
        });

    jQuery(".jd-hikashop-category-element .jd-slider-category-item-list a").on("click",function(e){
        e.preventDefault();
        jQuery(".jd-hikashop-category-element .jd-slider-category-item-list ul>li").removeClass('active');
        jQuery(this).parent().addClass("active");
        jQuery('.jd-hikashop-category-item-wrapper').hide();
        jQuery("#"+id+jQuery(this).attr('data-id')).show();
        jQuery(runningslider).slick('destroy');
        runningslider = "#"+id+jQuery(this).attr('data-id');
       jQuery(runningslider).slick({
            dots: <?php echo ($field['dis_bullets']) ? 'true' : 'false';?>,
            arrows: <?php echo ($field['dis_arrows']) ? 'true' : 'false';?>,
            touchMove: true,
            autoplay: <?php echo ($field['autoplay']) ? 'true' : 'false';?>,
            autoplaySpeed: <?php echo ($field['autoplay_speed']) ? $field['autoplay_speed'] : '1200';?>,
            slidesToShow: <?php echo $slide_count_desktop;?>,
            pauseOnHover: true,
            responsive: [
                {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: <?php echo $slide_count_desktop;?>,
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: <?php echo $slide_count_tablet;?>,
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: <?php echo $slide_count_phone;?>,
                    }
                }
            ]
        });
    })
});

</script>
<!-- qx-element-carousel -->