<?php
  $classes = classNames("qx-element qx-element-{$type} {$field['class']}", $visibilityClasses,[
    "wow {$field['animation']}" => $field['animation'],
    "qx-hvr-{$field['hover_animation']}" => $field['hover_animation']
  ]);
  $animation_delay = '';
  if( $field['animation'] AND array_key_exists('animation_delay', $field) ){
    $animation_delay = 'data-wow-delay="'. $field['animation_delay'] .'s"';
  }
  $app    = JFactory::getApplication();
  $doc = JFactory::getDocument();
  $templatedPath   = JURI::base(true).'/templates/'.$app->getTemplate().'/';  
  Assets::Css('qx-slick-theme', QUIX_URL."/assets/css/slick-theme.css");
  Assets::Css('qx-slick', QUIX_URL."/assets/css/slick.css");
  // JS script
  Assets::Js('qx-slick', QUIX_URL."/assets/js/slick.min.js");
  $rootPath = JURI::root();
  $rootPath = str_replace('https://', '', $rootPath);
  $rootPath = str_replace('http://', '', $rootPath);
  $rootPath = str_replace($_SERVER['SERVER_NAME'], '', $rootPath);
  
  $doc->addScript($rootPath."media/com_hikashop/js/hikashop.js?v=330");
  $doc->addScript($rootPath."plugins/hikashop/cartnotify/media/notify.min.js");
  $classes = classNames( "qx-element qx-element-{$type} {$field['class']}", $visibilityClasses);

  $productTypeList = array();
  $productTypeList['new_arrival'] = @($field['new_arrival'])?('New Arrival'):'';
  $productTypeList['hot_products'] = @($field['hot_products'])?('Hot Products'):'';
  $productTypeList['best_beller'] = @($field['best_beller'])?('Best Seller'):'';

  if( ! class_exists('JdHikashopCategories') )
	{
	  include_once ( __DIR__ . '/helper.php' );
	}
?>
<div class="jd-hikashop-categories-element <?php echo $classes;?>" <?php echo $animation_delay; ?> id="<?php echo $id;?>">
        <div class="container">
            <div class="jd-category-slider jd-hikashop-categories-wrapper">
                <div class="row jd-slider-row">
                    <div class="col-md-5 jd-slider-col">
                        <div class="jd-product-heading-wrapper">
                            <?php 
                                $title = ''; $subtitile = '';
                                if(@$field['title']){
                                    $title =  '<'.$field['title_tag'].' class="jd-slider-heading">'.$field['title'].'</'.$field['title_tag'].'>';
                                }
                                if(@$field['subtitle']){
                                    $subtitile =  '<p class="jd-slider-subHeading">'.$field['subtitle'].'</p>';
                                }
                                $titleText = $title . $subtitile;
                                if(@$field['subtitle_pos'] == 'Before'){
                                    $titleText = $subtitile . $title;
                                }
                                echo $titleText;
                            ?>                           
                        </div>
                    </div>
                    <div class="col-md-7 jd-slider-col">
                        <div class="jd-slider-category-item-list jd-hikashop-category-item-list">
                            <ul class="jd-unstyled-list">
                                <?php
                                    $catActiveClass =  'active';
                                    foreach ($field['cat_tabs'] as $prokey => $cat_tabs) {
                                        if($prokey === "title"){ 
                                           continue;
                                        }
                                        echo '<li class="categariestitle '.$catActiveClass.'" data-tabindex="catindex'.$prokey.'"><a href="#">'.$cat_tabs['tab_title'].'</a></li>';
                                        $catActiveClass = '';

                                    }
                                ?>                               
                            </ul>
                        </div>
                    </div>
                </div>
                <?php 
                $showClass = 'show';
                foreach ($field['cat_tabs'] as $prokey => $cat_tabs) {
                if($prokey === "title"){ 
                   continue;
                }
                $catFilter = str_replace(" ", "_", strtolower($cat_tabs['category_filter']));        
                $display_products = @($cat_tabs['display_products'])?($cat_tabs['display_products']):('4');        
                $item_in_on_row = @($cat_tabs['item_in_on_row'])?('col-list-'.$cat_tabs['item_in_on_row']):('col-list-2');        
                $productDetailsLists = @JdHikashopCategories::getCategoryProductList($cat_tabs['category'],$display_products)[$catFilter];
                if($productDetailsLists){               
                ?>
                <div class="jd-hikashop-categories-container catindex<?php echo $prokey;?>  <?php echo $showClass;?>">
                    <div class="jd-hikashop-categories-title-wrapper">
                        <div class="jd-hikashop-categories-title-container">
                            <h1 class="jd-hikashop-categories-title">
                                <?php echo $cat_tabs['tab_title'];?>
                            </h1>
                        </div>
                    </div>
                    <?php
                        $wrperClass = ($cat_tabs['tab_image'])?('with-banner'):'without-banner';
                    ?>
                    <div class="jd-hikashop-categories-item-wrapper <?php echo strtolower($cat_tabs['cat_image_pos']) . ' '.$wrperClass;?>">
                            <?php 
                            if($cat_tabs['tab_image']){ ?>
                            <div class="jd-hikashop-categories-banner-wrapper">
                                <a target="<?php echo $cat_tabs['cat_image_link_open'];?>" href="<?php echo ($cat_tabs['cat_image_link'])?($cat_tabs['cat_image_link']):('#');?>"><img src="<?php echo JURI::root().$cat_tabs['tab_image'];?>" alt=""></a>
                            </div>
                            <?php } ?>
                        <div class="jd-hikashop-categories-item-continer <?php echo $item_in_on_row;?>">
                        <?php 
                         $showClass = 'hide';
                        foreach ($productDetailsLists as $productDetail) { ?>                           
                            <div class="jd-hikashop-categories-item ">
                                <div class="jd-hikashop-categories-product-image">
                                    <a  href="<?php echo $productDetail['proLink'];?>"><img src="<?php echo $productDetail['image'];?>" alt=""></a>
                                </div>
                                <div class="jd-hikashop-categories-product-content">
                                    <div class="jd-slider-cart-wrapper">
                                        <ul class="jd-unstyled-list">
                                            <li class="jd-icon-cart"><a href="<?php echo $productDetail['cartLink'];?>" onclick="if(window.hikashop.addToCart) { return window.hikashop.addToCart(this); }" data-addtocart="<?php echo $productDetail['product_id'];?>"  data-addto-class="add_in_progress"></a></li>
                                            <li class="jd-icon-heart"><a href="<?php echo $productDetail['wishlistLink'];?>" onclick="if(window.hikashop.addToWishlist) { return window.hikashop.addToWishlist(this); }" data-addtowishlist="<?php echo $productDetail['product_id'];?> data-addto-class="add_in_progress"></a></li>
                                        </ul>
                                    </div>
                                    <div class="jd-slider-rating">
                                        <ul class="jd-unstyled-list">
                                           <?php 
                                                for ($i = 1 ; $i <= $productDetail['product_average_score']; $i++) {
                                                    echo '<li><a href="#"><span class="icon-star"></span></a></li>';
                                                }
                                            ?>  
                                        </ul>
                                    </div>
									<h5 class="jd-hikashop-categories-heading"><a href="#"><?php echo $productDetail['product_name']; ?></a></h5>
									<p class="jd-hikashop-categories-price"><a href="#"><?php echo $productDetail['price']; ?></a></p>
                                </div>
                            </div>

                        <?php } ?>
                        </div>
                    </div>
                </div>
                <?php } } ?>
            </div>
        </div>
    </div>
<script type="text/javascript">
    jQuery(document).ready(function(){
        jQuery(".categariestitle").on("click",function(e){
            e.preventDefault();
            jQuery(".categariestitle").removeClass("active");
            jQuery(this).addClass("active");
            jQuery(this).closest('.jd-hikashop-categories-wrapper').find(".jd-hikashop-categories-container").removeClass('show');
            jQuery(this).closest('.jd-hikashop-categories-wrapper').find(".jd-hikashop-categories-container").addClass('hide');
            jQuery(this).closest('.jd-hikashop-categories-wrapper').find("." + jQuery(this).attr('data-tabindex')).addClass('show');
        })
    })
</script>