<?php

if( ! class_exists('JdHikashopCategories') )
{
  include_once ( __DIR__ . '/helper.php' );
}

$articles = array_reduce( JdHikashopCategories::getCatList(), function ( $carry, $article ) {
  $carry[$article->category_id] = $article->category_name;
  return $carry;
}, [ ] );

return [
  'slug' => 'jd-JdHikashopCategories',
  'name' => 'JD Hikashop Categories',
  'groups' => 'JoomDev',
  'form' => [
    'general' => [  
       [
        'name' => 'title',
        'type' => 'text',
        'value' => 'Development',
      ],   
      [ 
        'name' => 'title_tag',
        'type' => 'select',
        'value' => 'h4',
        'label' => 'Title Tag',
        'options' => [
            'h1'=> 'H1',
            'h2'=> 'H2',
            'h3'=> 'H3',
            'h4'=> 'H4',
            'h5'=> 'H5',
            'h6'=> 'H6',
            'div'=> 'DIV',
        ]            
      ], 
      [
        'name' => 'subtitle',
        'type' => 'text',
        'value' => 'Sub-title',
      ],  
      [ 
        'name' => 'subtitle_pos',
        'type' => 'select',
        'value' => 'After',
        'label' => 'Subtitle Position',
        'options' => [
            'After'=> 'After',
            'Before'=> 'Before',            
        ]  
      ], 

      [
       'name' => 'cat_tabs',
       'type' => 'group-repeater',
        'schema' => [
          [
            'name' => 'tab_title',
            'value' => 'Tab Title',
          ],
          [
            'name' => 'tab_image',
            'label' => 'Select category display image',
            'type' => 'file-manager',
          ],
          [ 
            'name' => 'cat_image_pos',
            'type' => 'select',
            'value' => 'Left',
            'label' => 'Display Category Image Position',
            'options' => [
                'banner-left'=> 'Left',
                'banner-right'=> 'Right',            
            ]  
          ], 
          [ 
            'name' => 'cat_image_link',
            'label' => 'Category Image Link',
          ],
            [ 
            'name' => 'cat_image_link_open',
            'type' => 'select',
            'value' => '_blank',
            'label' => 'Open Category Image Link',
            'options' => [
                '_blank'=> 'Opens the linked document in a new window or tab',
                '_self'=> 'Opens the linked document in the same frame as it was clicked',            
                '_parent'=> 'Opens the linked document in the parent frame',            
                '_top'=> 'Opens the linked document in the full body of the window',            
            ]  
          ], 
          [ 
            'name' => 'category',
            'type' => 'select',
            'label' => 'Select Category',
            'options' => $articles
          ],  
          [ 
            'name' => 'category_filter',
            'type' => 'select',
            'value' => 'new_arrival',
            'label' => 'Filter product',
            'options' => [
                'new_arrival'=> 'New Arrival',
                'hot_products'=> 'Hot Products',            
                'best_seller'=> 'Best Seller',            
            ]  
          ], 
          [
            'name' => 'display_products',
            'label' => 'Number of products',
            'type' => 'text',
            'value' => '4',
          ], 
          [
            'name' => 'item_in_on_row',
            'label' => 'Item in one rows',
            'type' => 'select',
            'value' => '2',
            'options' => [
                '1'=> '1',
                '2'=> '2',
                '3'=> '3',
                '4'=> '4',
                '5'=> '5',
                '6'=> '6',
                '7'=> '7',
                '8'=> '8',
                '8'=> '9',
                '10'=> '10',
                '11'=> '11',
                '12'=> '12',
            ]  
          ], 


        ],
        'value' => [
          'title' => 'Tab Title',
        ]
      ],

    ],

    'styles' => [
      [
        'name' => 'title_styles',
        'type' => 'divider'
      ],

      [ 'name' => 'title_font',
        'type' => 'typography',
        'label' => 'Font'
      ],

      [ 'name' => 'title_color',
        'type' => 'color',
        'label' => 'Text Color'
      ],
      [
        'name' => 'sub_title_styles',
        'type' => 'divider'
      ],

      [ 'name' => 'sub_title_font',
        'type' => 'typography',
        'label' => 'Font'
      ],

      [ 'name' => 'sub_title_color',
        'type' => 'color',
        'label' => 'Text Color'
      ],

    ]
  ]
];
